/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.MpmcArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscCompoundQueue;
import io.netty.util.internal.shaded.org.jctools.queues.MpscLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SpmcArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SpscArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SpscLinkedQueue;
import io.netty.util.internal.shaded.org.jctools.queues.spec.ConcurrentQueueSpec;
import io.netty.util.internal.shaded.org.jctools.queues.spec.Ordering;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class QueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                if (qs.ordering != Ordering.NONE) {
                    return new MpscArrayQueue(qs.capacity);
                }
                return new MpscCompoundQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcArrayQueue(qs.capacity);
            }
            return new MpmcArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedQueue();
        }
        if (qs.isMpsc()) {
            return MpscLinkedQueue.newMpscLinkedQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

