/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues;

import io.netty.util.internal.shaded.org.jctools.queues.BaseSpscLinkedArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.CircularArrayOffsetCalculator;
import io.netty.util.internal.shaded.org.jctools.queues.LinkedArrayQueueUtil;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.netty.util.internal.shaded.org.jctools.queues.SpscArrayQueue;
import io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;

public class SpscGrowableArrayQueue<E>
extends BaseSpscLinkedArrayQueue<E> {
    private final int maxQueueCapacity;
    private long lookAheadStep;

    public SpscGrowableArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscGrowableArrayQueue(int chunkSize, int capacity) {
        RangeUtil.checkGreaterThanOrEqual(capacity, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(chunkSize, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        RangeUtil.checkLessThan(chunkCapacity, this.maxQueueCapacity, "chunkCapacity");
        long mask = chunkCapacity - 1;
        E[] buffer = CircularArrayOffsetCalculator.allocate(chunkCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.adjustLookAheadStep(chunkCapacity);
    }

    @Override
    final boolean offerColdPath(E[] buffer, long mask, long index, long offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        int maxCapacity;
        long lookAheadStep = this.lookAheadStep;
        if (lookAheadStep > 0L) {
            long lookAheadElementOffset = CircularArrayOffsetCalculator.calcElementOffset(index + lookAheadStep, mask);
            if (null == UnsafeRefArrayAccess.lvElement(buffer, lookAheadElementOffset)) {
                this.producerBufferLimit = index + lookAheadStep - 1L;
                this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
                return true;
            }
            int maxCapacity2 = this.maxQueueCapacity;
            if (mask + 1L == (long)maxCapacity2) {
                if (null == UnsafeRefArrayAccess.lvElement(buffer, offset)) {
                    this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
                    return true;
                }
                return false;
            }
            if (null == UnsafeRefArrayAccess.lvElement(buffer, CircularArrayOffsetCalculator.calcElementOffset(index + 1L, mask))) {
                this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
            } else {
                Object[] newBuffer = CircularArrayOffsetCalculator.allocate((int)(2L * (mask + 1L) + 1L));
                this.producerBuffer = newBuffer;
                this.producerMask = LinkedArrayQueueUtil.length(newBuffer) - 2;
                long offsetInNew = CircularArrayOffsetCalculator.calcElementOffset(index, this.producerMask);
                this.linkOldToNew(index, buffer, offset, newBuffer, offsetInNew, v == null ? s.get() : v);
                int newCapacity = (int)(this.producerMask + 1L);
                if (newCapacity == maxCapacity2) {
                    long currConsumerIndex = this.lvConsumerIndex();
                    this.lookAheadStep = -(index - currConsumerIndex);
                    this.producerBufferLimit = currConsumerIndex + (long)maxCapacity2 - 1L;
                } else {
                    this.producerBufferLimit = index + this.producerMask - 1L;
                    this.adjustLookAheadStep(newCapacity);
                }
            }
            return true;
        }
        long prevElementsInOtherBuffers = -lookAheadStep;
        long currConsumerIndex = this.lvConsumerIndex();
        int size = (int)(index - currConsumerIndex);
        if (size == (maxCapacity = (int)mask + 1)) {
            return false;
        }
        long firstIndexInCurrentBuffer = this.producerBufferLimit - (long)maxCapacity + prevElementsInOtherBuffers;
        if (currConsumerIndex >= firstIndexInCurrentBuffer) {
            this.adjustLookAheadStep(maxCapacity);
        } else {
            this.lookAheadStep = (int)(currConsumerIndex - firstIndexInCurrentBuffer);
        }
        this.producerBufferLimit = currConsumerIndex + (long)maxCapacity;
        this.writeToQueue(buffer, v == null ? s.get() : v, index, offset);
        return true;
    }

    private void adjustLookAheadStep(int capacity) {
        this.lookAheadStep = Math.min(capacity / 4, SpscArrayQueue.MAX_LOOK_AHEAD_STEP);
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

