/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpmcAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscLinkedAtomicQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.SpmcAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.SpscAtomicArrayQueue;
import io.netty.util.internal.shaded.org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import io.netty.util.internal.shaded.org.jctools.queues.spec.ConcurrentQueueSpec;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AtomicQueueFactory {
    public static <E> Queue<E> newQueue(ConcurrentQueueSpec qs) {
        if (qs.isBounded()) {
            if (qs.isSpsc()) {
                return new SpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isMpsc()) {
                return new MpscAtomicArrayQueue(qs.capacity);
            }
            if (qs.isSpmc()) {
                return new SpmcAtomicArrayQueue(qs.capacity);
            }
            return new MpmcAtomicArrayQueue(qs.capacity);
        }
        if (qs.isSpsc()) {
            return new SpscLinkedAtomicQueue();
        }
        if (qs.isMpsc()) {
            return new MpscLinkedAtomicQueue();
        }
        return new ConcurrentLinkedQueue();
    }
}

