/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.Objects;
import redis.clients.jedis.util.ByteArrayComparator;
import redis.clients.jedis.util.SafeEncoder;

public class Tuple
implements Comparable<Tuple> {
    private byte[] element;
    private Double score;

    public Tuple(String element, Double score) {
        this(SafeEncoder.encode(element), score);
    }

    public Tuple(byte[] element, Double score) {
        this.element = element;
        this.score = score;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (null != this.element) {
            for (byte b : this.element) {
                result = 31 * result + b;
            }
        }
        long temp = Double.doubleToLongBits(this.score);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)obj;
        if (!Arrays.equals(this.element, other.element)) {
            return false;
        }
        return Objects.equals(this.score, other.score);
    }

    @Override
    public int compareTo(Tuple other) {
        return Tuple.compare(this, other);
    }

    public static int compare(Tuple t1, Tuple t2) {
        int compScore = Double.compare(t1.score, t2.score);
        if (compScore != 0) {
            return compScore;
        }
        return ByteArrayComparator.compare(t1.element, t2.element);
    }

    public String getElement() {
        if (null != this.element) {
            return SafeEncoder.encode(this.element);
        }
        return null;
    }

    public byte[] getBinaryElement() {
        return this.element;
    }

    public double getScore() {
        return this.score;
    }

    public String toString() {
        return "[" + SafeEncoder.encode(this.element) + "," + this.score + "]";
    }
}

