/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.weicoder.common.lang.Lists;
import com.weicoder.common.log.Logs;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.common.util.EmptyUtil;
import com.weicoder.json.Json;
import java.util.Collection;
import java.util.List;

public final class GsonJson
implements Json {
    private static final Gson GSON = new GsonBuilder().create();

    public String toJson(Object obj) {
        return GSON.toJson(obj);
    }

    public <E> E toBean(String json, Class<E> clazz) {
        try {
            return (E)GSON.fromJson(json, clazz);
        }
        catch (Exception e) {
            Logs.debug((String)("JsonGson toBean=" + e.toString()), (Object[])new Object[0]);
            return null;
        }
    }

    public <E> List<E> toList(String json, Class<E> clazz) {
        try {
            List list = (List)GSON.fromJson(json, new TypeToken<E>(){}.getType());
            if (!EmptyUtil.isEmpty((Collection)list) && !list.get(0).getClass().equals(clazz)) {
                List ls = Lists.newList((int)list.size());
                for (Object o : list) {
                    ls.add(BeanUtil.copy(o, clazz));
                }
                return ls;
            }
            return list;
        }
        catch (Exception e) {
            Logs.debug((String)("JsonGson toList=" + e.toString()), (Object[])new Object[0]);
            return Lists.newList();
        }
    }
}

