/*
 * Decompiled with CFR 0.152.
 */
package com.weicoder.json;

import com.weicoder.common.U;
import com.weicoder.common.W;
import com.weicoder.common.constants.ArrayConstants;
import com.weicoder.common.lang.Maps;
import com.weicoder.common.util.BeanUtil;
import com.weicoder.fastjson.FastJson;
import com.weicoder.json.Json;
import java.util.List;
import java.util.Map;

public final class JsonEngine {
    private static final Json JSON = new FastJson();

    public static boolean isJson(String json) {
        if (U.E.isEmpty((String)json)) {
            return false;
        }
        if (JsonEngine.isObject(json)) {
            return true;
        }
        return JsonEngine.isArray(json);
    }

    public static boolean isObject(String json) {
        if (U.E.isEmpty((String)json)) {
            return false;
        }
        if (json.startsWith("{") && json.endsWith("}")) {
            return true;
        }
        return json.equals("{}");
    }

    public static boolean isArray(String json) {
        if (U.E.isEmpty((String)json)) {
            return false;
        }
        if (json.startsWith("[{") && json.endsWith("}]")) {
            return true;
        }
        return json.equals("[]");
    }

    public static String toJson(Object obj) {
        return obj == null ? "" : JSON.toJson(obj);
    }

    public static List<String> toJsonByList(List<?> list) {
        return W.L.newList((Object[])JsonEngine.toJsonByArray(list));
    }

    public static String[] toJsonByArray(List<?> list) {
        if (U.E.isEmpty(list)) {
            return ArrayConstants.STRING_EMPTY;
        }
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = JsonEngine.toJson(list.get(0));
        }
        return array;
    }

    public static <E> E toBean(String json, Class<E> clazz) {
        return U.E.isEmpty((String)json) ? null : (E)JSON.toBean(json, clazz);
    }

    public static <E> List<E> toList(String json, Class<E> clazz) {
        return W.L.newList(JSON.toList(json, clazz));
    }

    public static Map<String, Object> toMap(String json) {
        return JsonEngine.toBean(json, Map.class);
    }

    public static <E> Map<String, E> toMap(String json, Class<E> value) {
        Map map = JsonEngine.toBean(json, Map.class);
        if (U.E.isEmpty((Map)map)) {
            return Maps.newMap();
        }
        Map data = Maps.newMap((int)map.size());
        map.forEach((k, v) -> {
            Object val = null;
            val = v.equals(value) ? v : BeanUtil.copy((Object)v, (Class)value);
            data.put(k, val);
        });
        return data;
    }

    public static List<Object> toList(String json) {
        return JsonEngine.toList(json, Object.class);
    }

    private JsonEngine() {
    }
}

