/*
 * Decompiled with CFR 0.152.
 */
package com.wf2311.swagger.configuration;

import com.wf2311.swagger.properties.SwaggerConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerConfigurationProperties.class})
public class SwaggerConfiguration
extends WebMvcConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfiguration.class);
    private final SwaggerConfigurationProperties properties;

    public SwaggerConfiguration(SwaggerConfigurationProperties properties) {
        this.properties = properties;
        log.info("using springfox.swagger2 with properties='{}'", (Object)properties);
    }

    @Bean
    public WebMvcConfigurerAdapter forwardToIndex() {
        return new WebMvcConfigurerAdapter(){

            public void addViewControllers(ViewControllerRegistry registry) {
                if (SwaggerConfiguration.this.properties.getRedirect().booleanValue()) {
                    registry.addViewController("/").setViewName("redirect:/swagger-ui.html");
                }
            }
        };
    }

    @Bean
    public Docket docket() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.properties.getBasePackage())).paths(PathSelectors.any()).build();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui.html**"}).addResourceLocations(new String[]{"classpath:/swagger-ui.html"});
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).version(this.properties.getVersion()).build();
    }
}

