/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.collection;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.Assert;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineIter
implements Iterator<String>,
Iterable<String>,
Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedReader bufferedReader;
    private String cachedLine;
    private boolean finished = false;

    public LineIter(InputStream in, Charset charset) throws IllegalArgumentException {
        this(IoUtil.getReader(in, charset));
    }

    public LineIter(Reader reader) throws IllegalArgumentException {
        Assert.notNull(reader, "Reader must not be null", new Object[0]);
        this.bufferedReader = IoUtil.getReader(reader);
    }

    @Override
    public boolean hasNext() throws IORuntimeException {
        if (this.cachedLine != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        try {
            String line;
            do {
                if ((line = this.bufferedReader.readLine()) != null) continue;
                this.finished = true;
                return false;
            } while (!this.isValidLine(line));
            this.cachedLine = line;
            return true;
        }
        catch (IOException ioe) {
            this.close();
            throw new IORuntimeException(ioe);
        }
    }

    @Override
    public String next() throws NoSuchElementException {
        return this.nextLine();
    }

    public String nextLine() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines");
        }
        String currentLine = this.cachedLine;
        this.cachedLine = null;
        return currentLine;
    }

    @Override
    public void close() {
        this.finished = true;
        IoUtil.close(this.bufferedReader);
        this.cachedLine = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove unsupported on LineIterator");
    }

    protected boolean isValidLine(String line) {
        return true;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

