/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.comparator;

import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.core.util.ArrayUtil;
import java.io.Serializable;
import java.util.Comparator;

public class IndexedComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean atEndIfMiss;
    private final T[] array;

    public IndexedComparator(T ... objs) {
        this(false, objs);
    }

    public IndexedComparator(boolean atEndIfMiss, T ... objs) {
        Assert.notNull(objs, "'objs' array must not be null", new Object[0]);
        this.atEndIfMiss = atEndIfMiss;
        this.array = objs;
    }

    @Override
    public int compare(T o1, T o2) {
        int index1 = this.getOrder(o1);
        int index2 = this.getOrder(o2);
        return Integer.compare(index1, index2);
    }

    private int getOrder(T object) {
        int order = ArrayUtil.indexOf(this.array, object);
        if (order < 0) {
            order = this.atEndIfMiss ? this.array.length : -1;
        }
        return order;
    }
}

