/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.io.file;

import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.core.lang.copier.SrcToDestCopier;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public class FileCopier
extends SrcToDestCopier<File, FileCopier> {
    private static final long serialVersionUID = 1L;
    private boolean isOverride;
    private boolean isCopyAttributes;
    private boolean isCopyContentIfDir;
    private boolean isOnlyCopyFile;
    public static final int BUFFER_SIZE = 4096;

    public static FileCopier create(String srcPath, String destPath) {
        return new FileCopier(FileUtil.file(srcPath), FileUtil.file(destPath));
    }

    public static FileCopier create(File src, File dest) {
        return new FileCopier(src, dest);
    }

    public FileCopier(File src, File dest) {
        this.src = src;
        this.dest = dest;
    }

    public boolean isOverride() {
        return this.isOverride;
    }

    public FileCopier setOverride(boolean isOverride) {
        this.isOverride = isOverride;
        return this;
    }

    public boolean isCopyAttributes() {
        return this.isCopyAttributes;
    }

    public FileCopier setCopyAttributes(boolean isCopyAttributes) {
        this.isCopyAttributes = isCopyAttributes;
        return this;
    }

    public boolean isCopyContentIfDir() {
        return this.isCopyContentIfDir;
    }

    public FileCopier setCopyContentIfDir(boolean isCopyContentIfDir) {
        this.isCopyContentIfDir = isCopyContentIfDir;
        return this;
    }

    public boolean isOnlyCopyFile() {
        return this.isOnlyCopyFile;
    }

    public FileCopier setOnlyCopyFile(boolean isOnlyCopyFile) {
        this.isOnlyCopyFile = isOnlyCopyFile;
        return this;
    }

    @Override
    public File copy() throws IORuntimeException {
        File src = (File)this.src;
        File dest = (File)this.dest;
        Assert.notNull(src, "Source File is null !", new Object[0]);
        if (!src.exists()) {
            throw new IORuntimeException("File not exist: " + src);
        }
        Assert.notNull(dest, "Destination File or directiory is null !", new Object[0]);
        if (FileUtil.equals(src, dest)) {
            throw new IORuntimeException("Files '{}' and '{}' are equal", src, dest);
        }
        if (src.isDirectory()) {
            if (dest.exists() && !dest.isDirectory()) {
                throw new IORuntimeException("Src is a directory but dest is a file!");
            }
            if (FileUtil.isSub(src, dest)) {
                throw new IORuntimeException("Dest is a sub directory of src !");
            }
            File subTarget = this.isCopyContentIfDir ? dest : FileUtil.mkdir(FileUtil.file(dest, src.getName()));
            this.internalCopyDirContent(src, subTarget);
        } else {
            this.internalCopyFile(src, dest);
        }
        return dest;
    }

    public static long copy(File in, File out) throws IOException {
        Assert.notNull(in, "No input File specified", new Object[0]);
        Assert.notNull(out, "No output File specified", new Object[0]);
        return FileCopier.copy(Files.newInputStream(in.toPath(), new OpenOption[0]), Files.newOutputStream(out.toPath(), new OpenOption[0]));
    }

    public static void copy(byte[] in, File out) throws IOException {
        Assert.notNull(in, "No input byte array specified", new Object[0]);
        Assert.notNull(out, "No output File specified", new Object[0]);
        FileCopier.copy(new ByteArrayInputStream(in), Files.newOutputStream(out.toPath(), new OpenOption[0]));
    }

    public static byte[] copyToByteArray(File in) throws IOException {
        Assert.notNull(in, "No input File specified", new Object[0]);
        return FileCopier.copyToByteArray(Files.newInputStream(in.toPath(), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, OutputStream out) throws IOException {
        Assert.notNull(in, "No InputStream specified", new Object[0]);
        Assert.notNull(out, "No OutputStream specified", new Object[0]);
        try {
            long l = IoUtil.copy(in, out);
            return l;
        }
        finally {
            FileCopier.close(in);
            FileCopier.close(out);
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assert.notNull(in, "No input byte array specified", new Object[0]);
        Assert.notNull(out, "No OutputStream specified", new Object[0]);
        try {
            out.write(in);
        }
        finally {
            FileCopier.close(out);
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileCopier.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, Writer out) throws IOException {
        Assert.notNull(in, "No Reader specified", new Object[0]);
        Assert.notNull(out, "No Writer specified", new Object[0]);
        try {
            int charsRead;
            int charCount = 0;
            char[] buffer = new char[4096];
            while ((charsRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, charsRead);
                charCount += charsRead;
            }
            out.flush();
            int n = charCount;
            return n;
        }
        finally {
            FileCopier.close(in);
            FileCopier.close(out);
        }
    }

    public static void copy(String in, Writer out) throws IOException {
        Assert.notNull(in, "No input String specified", new Object[0]);
        Assert.notNull(out, "No Writer specified", new Object[0]);
        try {
            out.write(in);
        }
        finally {
            FileCopier.close(out);
        }
    }

    public static String copyToString(Reader in) throws IOException {
        if (in == null) {
            return "";
        }
        StringWriter out = new StringWriter(4096);
        FileCopier.copy(in, (Writer)out);
        return out.toString();
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void internalCopyDirContent(File src, File dest) throws IORuntimeException {
        if (null != this.copyFilter && !this.copyFilter.accept(src)) {
            return;
        }
        if (!dest.exists()) {
            dest.mkdirs();
        } else if (!dest.isDirectory()) {
            throw new IORuntimeException(StrUtil.format("Src [{}] is a directory but dest [{}] is a file!", src.getPath(), dest.getPath()));
        }
        String[] files = src.list();
        if (ArrayUtil.isNotEmpty(files)) {
            for (String file : files) {
                File destFile;
                File srcFile = new File(src, file);
                File file2 = destFile = this.isOnlyCopyFile ? dest : new File(dest, file);
                if (srcFile.isDirectory()) {
                    this.internalCopyDirContent(srcFile, destFile);
                    continue;
                }
                this.internalCopyFile(srcFile, destFile);
            }
        }
    }

    private void internalCopyFile(File src, File dest) throws IORuntimeException {
        if (null != this.copyFilter && !this.copyFilter.accept(src)) {
            return;
        }
        if (dest.exists()) {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (dest.exists() && !this.isOverride) {
                return;
            }
        } else {
            dest.getParentFile().mkdirs();
        }
        ArrayList<StandardCopyOption> optionList = new ArrayList<StandardCopyOption>(2);
        if (this.isOverride) {
            optionList.add(StandardCopyOption.REPLACE_EXISTING);
        }
        if (this.isCopyAttributes) {
            optionList.add(StandardCopyOption.COPY_ATTRIBUTES);
        }
        try {
            Files.copy(src.toPath(), dest.toPath(), optionList.toArray(new CopyOption[0]));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

