/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.stream;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.core.stream.CollectorUtil;
import com.whaleal.icefrog.core.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtil {
    @SafeVarargs
    public static <T> Stream<T> of(T ... array) {
        Assert.notNull(array, "Array must be not null!", new Object[0]);
        return Stream.of(array);
    }

    public static <T> Stream<T> of(Iterable<T> iterable) {
        return StreamUtil.of(iterable, false);
    }

    public static <T> Stream<T> of(Iterable<T> iterable, boolean parallel) {
        Assert.notNull(iterable, "Iterable must be not null!", new Object[0]);
        return StreamSupport.stream(Spliterators.spliterator(CollUtil.toCollection(iterable), 0), parallel);
    }

    public static Stream<String> of(File file) {
        return StreamUtil.of(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static Stream<String> of(Path path) {
        return StreamUtil.of(path, CharsetUtil.CHARSET_UTF_8);
    }

    public static Stream<String> of(File file, Charset charset) {
        Assert.notNull(file, "File must be not null!", new Object[0]);
        return StreamUtil.of(file.toPath(), charset);
    }

    public static Stream<String> of(Path path, Charset charset) {
        try {
            return Files.lines(path, charset);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <T> Stream<T> of(T seed, UnaryOperator<T> elementCreator, int limit) {
        return Stream.iterate(seed, elementCreator).limit(limit);
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter) {
        return stream.collect(CollectorUtil.joining(delimiter));
    }

    public static <T> String join(Stream<T> stream, CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        return stream.collect(CollectorUtil.joining(delimiter, toStringFunc));
    }
}

