/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.CollectionUtil;
import com.whaleal.icefrog.core.comparator.CompareUtil;
import com.whaleal.icefrog.core.exceptions.UtilException;
import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.core.lang.Editor;
import com.whaleal.icefrog.core.lang.Filter;
import com.whaleal.icefrog.core.lang.Matcher;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.text.CharSequenceUtil;
import com.whaleal.icefrog.core.text.StrJoiner;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.PrimitiveArrayUtil;
import com.whaleal.icefrog.core.util.RandomUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ArrayUtil
extends PrimitiveArrayUtil {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final int INDEX_NOT_FOUND = -1;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultArray) {
        return ArrayUtil.isEmpty(array) ? defaultArray : array;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (ArrayUtil.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return null != array && array.length != 0;
    }

    public static boolean isNotEmpty(Object array) {
        return false == ArrayUtil.isEmpty(array);
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T element : array) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isAllNull(T ... array) {
        return null == ArrayUtil.firstNonNull(array);
    }

    public static <T> T firstNonNull(T ... array) {
        return (T)ArrayUtil.firstMatch(Objects::nonNull, array);
    }

    public static <T> T firstMatch(Matcher<T> matcher, T ... array) {
        int index = ArrayUtil.matchIndex(matcher, array);
        if (index < 0) {
            return null;
        }
        return array[index];
    }

    public static <T> int matchIndex(Matcher<T> matcher, T ... array) {
        return ArrayUtil.matchIndex(matcher, 0, array);
    }

    public static <T> int matchIndex(Matcher<T> matcher, int beginIndexInclude, T ... array) {
        Assert.notNull(matcher, "Matcher must be not null !", new Object[0]);
        if (ArrayUtil.isNotEmpty(array)) {
            for (int i = beginIndexInclude; i < array.length; ++i) {
                if (!matcher.match(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : array.getClass().getComponentType();
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayUtil.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtil.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtil.insert(buffer, buffer.length, newElements);
    }

    @SafeVarargs
    public static <T> Object append(Object array, T ... newElements) {
        if (ArrayUtil.isEmpty(array)) {
            return newElements;
        }
        return ArrayUtil.insert(array, ArrayUtil.length(array), newElements);
    }

    public static <T> T[] setOrAppend(T[] buffer, int index, T value) {
        if (index < buffer.length) {
            Array.set(buffer, index, value);
            return buffer;
        }
        return ArrayUtil.append(buffer, value);
    }

    public static Object setOrAppend(Object array, int index, Object value) {
        if (index < ArrayUtil.length(array)) {
            Array.set(array, index, value);
            return array;
        }
        return ArrayUtil.append(array, value);
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])ArrayUtil.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return array;
        }
        if (ArrayUtil.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayUtil.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static <T> T[] resize(T[] data, int newSize, Class<?> componentType) {
        if (newSize < 0) {
            return data;
        }
        T[] newArray = ArrayUtil.newArray(componentType, newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(data)) {
            System.arraycopy(data, 0, newArray, 0, Math.min(data.length, newSize));
        }
        return newArray;
    }

    public static Object resize(Object array, int newSize) {
        if (newSize < 0) {
            return array;
        }
        if (null == array) {
            return null;
        }
        int length = ArrayUtil.length(array);
        Object newArray = Array.newInstance(array.getClass().getComponentType(), newSize);
        if (newSize > 0 && ArrayUtil.isNotEmpty(array)) {
            System.arraycopy(array, 0, newArray, 0, Math.min(length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtil.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        T[] result = ArrayUtil.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T[] edit(T[] array, Editor<T> editor) {
        if (null == editor) {
            return array;
        }
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(modified);
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), list.size());
        return list.toArray(result);
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        if (null == array || null == filter) {
            return array;
        }
        return ArrayUtil.edit(array, t -> filter.accept(t) ? t : null);
    }

    public static <T> T[] removeNull(T[] array) {
        return ArrayUtil.edit(array, t -> t);
    }

    public static <T extends CharSequence> T[] removeEmpty(T[] array) {
        return ArrayUtil.filter(array, CharSequenceUtil::isNotEmpty);
    }

    public static <T extends CharSequence> T[] removeBlank(T[] array) {
        return ArrayUtil.filter(array, CharSequenceUtil::isNotBlank);
    }

    public static String[] nullToEmpty(String[] array) {
        return ArrayUtil.edit(array, t -> null == t ? "" : t);
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ArrayUtil.isEmpty(keys) || ArrayUtil.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = MapUtil.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        return ArrayUtil.zip(keys, values, false);
    }

    public static <T> int indexOf(T[] array, Object value, int beginIndexInclude) {
        return ArrayUtil.matchIndex((T obj) -> ObjectUtil.equal(value, obj), beginIndexInclude, array);
    }

    public static <T> int indexOf(T[] array, Object value) {
        return ArrayUtil.matchIndex((T obj) -> ObjectUtil.equal(value, obj), array);
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!StrUtil.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, Object value) {
        if (ArrayUtil.isEmpty(array)) {
            return -1;
        }
        return ArrayUtil.lastIndexOf(array, value, array.length - 1);
    }

    public static <T> int lastIndexOf(T[] array, Object value, int endInclude) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (int i = endInclude; i >= 0; --i) {
                if (!ObjectUtil.equal(value, array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static <T> boolean containsAny(T[] array, T ... values) {
        for (T value : values) {
            if (!ArrayUtil.contains(array, value)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsAll(T[] array, T ... values) {
        for (T value : values) {
            if (ArrayUtil.contains(array, value)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayUtil.indexOfIgnoreCase(array, value) > -1;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtil.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayUtil.wrap((int[])obj);
                    }
                    case "short": {
                        return ArrayUtil.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayUtil.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayUtil.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayUtil.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayUtil.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayUtil.wrap((double[])obj);
                    }
                }
                throw new UtilException(e);
            }
        }
        throw new UtilException(StrUtil.format("[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static <T> T get(Object array, int index) {
        if (null == array) {
            return null;
        }
        if (index < 0) {
            index += Array.getLength(array);
        }
        try {
            return (T)Array.get(array, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static <T> T[] getAny(Object array, int ... indexes) {
        if (null == array) {
            return null;
        }
        T[] result = ArrayUtil.newArray(array.getClass().getComponentType(), indexes.length);
        for (int i : indexes) {
            result[i] = ArrayUtil.get(array, i);
        }
        return result;
    }

    public static <T> T[] sub(T[] array, int start, int end) {
        int length = ArrayUtil.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return ArrayUtil.newArray(array.getClass().getComponentType(), 0);
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static Object[] sub(Object array, int start, int end) {
        return ArrayUtil.sub(array, start, end, 1);
    }

    public static Object[] sub(Object array, int start, int end, int step) {
        int length = ArrayUtil.length(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new Object[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new Object[0];
            }
            end = length;
        }
        if (step <= 1) {
            step = 1;
        }
        ArrayList list = new ArrayList();
        for (int i = start; i < end; i += step) {
            list.add(ArrayUtil.get(array, i));
        }
        return list.toArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return ArrayUtil.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        return StrJoiner.of(delimiter, prefix, suffix).setWrapElement(true).append(array).toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction, Editor<T> editor) {
        return StrJoiner.of(conjunction).append(array, t -> String.valueOf(editor.edit(t))).toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        if (!ArrayUtil.isArray(array)) {
            throw new IllegalArgumentException(StrUtil.format("[{}] is not a Array!", array.getClass()));
        }
        return StrJoiner.of(conjunction).append(array).toString();
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (bytebuffer.hasArray()) {
            return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
        }
        int oldPosition = bytebuffer.position();
        bytebuffer.position(0);
        int size = bytebuffer.limit();
        byte[] buffers = new byte[size];
        bytebuffer.get(buffers);
        bytebuffer.position(oldPosition);
        return buffers;
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayUtil.toArray(CollUtil.newArrayList(iterator), componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayUtil.toArray(CollectionUtil.toCollection(iterable), componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        return collection.toArray(ArrayUtil.newArray(componentType, 0));
    }

    public static <T> T[] remove(T[] array, int index) throws IllegalArgumentException {
        return (Object[])ArrayUtil.remove(array, index);
    }

    public static <T> T[] removeEle(T[] array, T element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = Math.max(startIndexInclusive, 0);
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtil.min(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray, Comparator<T> comparator) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (T t : numberArray) {
            if (CompareUtil.compare(min, t, comparator) <= 0) continue;
            min = t;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtil.max(numberArray, null);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator) {
        if (ArrayUtil.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (CompareUtil.compare(max, numberArray[i], comparator) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <T> T[] shuffle(T[] array) {
        return ArrayUtil.shuffle(array, (Random)RandomUtil.getRandom());
    }

    public static <T> T[] shuffle(T[] array, Random random) {
        if (array == null || random == null || array.length <= 1) {
            return array;
        }
        for (int i = array.length; i > 1; --i) {
            ArrayUtil.swap(array, i - 1, random.nextInt(i));
        }
        return array;
    }

    public static <T> T[] swap(T[] array, int index1, int index2) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        T tmp = array[index1];
        array[index1] = array[index2];
        array[index2] = tmp;
        return array;
    }

    public static Object swap(Object array, int index1, int index2) {
        if (ArrayUtil.isEmpty(array)) {
            throw new IllegalArgumentException("Array must not empty !");
        }
        Object tmp = ArrayUtil.get(array, index1);
        Array.set(array, index1, Array.get(array, index2));
        Array.set(array, index2, tmp);
        return array;
    }

    public static int emptyCount(Object ... args) {
        int count = 0;
        if (ArrayUtil.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectUtil.isEmpty(element)) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean hasEmpty(Object ... args) {
        if (ArrayUtil.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectUtil.isEmpty(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAllEmpty(Object ... args) {
        return ArrayUtil.emptyCount(args) == args.length;
    }

    public static boolean isAllNotEmpty(Object ... args) {
        return false == ArrayUtil.hasEmpty(args);
    }

    public static <T> boolean isAllNotNull(T ... array) {
        return false == ArrayUtil.hasNull(array);
    }

    public static <T> T[] distinct(T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ArrayUtil.toArray(set, ArrayUtil.getComponentType(array));
    }

    public static <T, R> R[] map(T[] array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        T[] result = ArrayUtil.newArray(targetComponentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = func.apply(array[i]);
        }
        return result;
    }

    public static <T, R> R[] map(Object array, Class<R> targetComponentType, Function<? super T, ? extends R> func) {
        int length = ArrayUtil.length(array);
        T[] result = ArrayUtil.newArray(targetComponentType, length);
        for (int i = 0; i < length; ++i) {
            result[i] = func.apply(ArrayUtil.get(array, i));
        }
        return result;
    }

    public static <T, R> List<R> map(T[] array, Function<? super T, ? extends R> func) {
        return Arrays.stream(array).map(func).collect(Collectors.toList());
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (ArrayUtil.hasNull(array1, array2)) {
            return false;
        }
        Assert.isTrue(ArrayUtil.isArray(array1), "First is not a Array !");
        Assert.isTrue(ArrayUtil.isArray(array2), "Second is not a Array !");
        if (array1 instanceof long[]) {
            return Arrays.equals((long[])array1, (long[])array2);
        }
        if (array1 instanceof int[]) {
            return Arrays.equals((int[])array1, (int[])array2);
        }
        if (array1 instanceof short[]) {
            return Arrays.equals((short[])array1, (short[])array2);
        }
        if (array1 instanceof char[]) {
            return Arrays.equals((char[])array1, (char[])array2);
        }
        if (array1 instanceof byte[]) {
            return Arrays.equals((byte[])array1, (byte[])array2);
        }
        if (array1 instanceof double[]) {
            return Arrays.equals((double[])array1, (double[])array2);
        }
        if (array1 instanceof float[]) {
            return Arrays.equals((float[])array1, (float[])array2);
        }
        if (array1 instanceof boolean[]) {
            return Arrays.equals((boolean[])array1, (boolean[])array2);
        }
        return Arrays.deepEquals((Object[])array1, (Object[])array2);
    }

    public static <T> boolean isSub(T[] array, T[] subArray) {
        return ArrayUtil.indexOfSub(array, subArray) > -1;
    }

    public static <T> int indexOfSub(T[] array, T[] subArray) {
        return ArrayUtil.indexOfSub(array, 0, subArray);
    }

    public static <T> int indexOfSub(T[] array, int beginInclude, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length) {
            return -1;
        }
        int firstIndex = ArrayUtil.indexOf(array, subArray[0], beginInclude);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectUtil.equal(array[i + firstIndex], subArray[i])) continue;
            return ArrayUtil.indexOfSub(array, firstIndex + 1, subArray);
        }
        return firstIndex;
    }

    public static <T> int lastIndexOfSub(T[] array, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray)) {
            return -1;
        }
        return ArrayUtil.lastIndexOfSub(array, array.length - 1, subArray);
    }

    public static <T> int lastIndexOfSub(T[] array, int endInclude, T[] subArray) {
        if (ArrayUtil.isEmpty(array) || ArrayUtil.isEmpty(subArray) || subArray.length > array.length || endInclude < 0) {
            return -1;
        }
        int firstIndex = ArrayUtil.lastIndexOf(array, subArray[0]);
        if (firstIndex < 0 || firstIndex + subArray.length > array.length) {
            return -1;
        }
        for (int i = 0; i < subArray.length; ++i) {
            if (ObjectUtil.equal(array[i + firstIndex], subArray[i])) continue;
            return ArrayUtil.lastIndexOfSub(array, firstIndex - 1, subArray);
        }
        return firstIndex;
    }

    public static <T> boolean isSorted(T[] array, Comparator<? super T> comparator) {
        if (array == null || comparator == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (comparator.compare(array[i], array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayUtil.isSortedASC(array);
    }

    public static <T extends Comparable<? super T>> boolean isSortedDESC(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<? super T>> boolean isSortedASC(T[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length - 1; ++i) {
            if (array[i].compareTo(array[i + 1]) <= 0) continue;
            return false;
        }
        return true;
    }

    public static int arrayLength(Object array) {
        return ArrayUtil.arrayLength(array, 0, 0);
    }

    private static int arrayLength(Object array, int defaultIfNull, int defaultIfNotArray) {
        if (array == null) {
            return defaultIfNull;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        return defaultIfNotArray;
    }

    public static boolean isEmptyArray(Object array) {
        return ArrayUtil.arrayLength(array, 0, -1) == 0;
    }

    public static <T, S extends T> T defaultIfEmptyArray(T array, S defaultValue) {
        return (T)(ArrayUtil.isEmptyArray(array) ? defaultValue : array);
    }

    public static boolean isArraySameLength(Object[] array1, Object[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(long[] array1, long[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(int[] array1, int[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(short[] array1, short[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(byte[] array1, byte[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(double[] array1, double[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(float[] array1, float[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(boolean[] array1, boolean[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static boolean isArraySameLength(char[] array1, char[] array2) {
        int length1 = array1 == null ? 0 : array1.length;
        int length2 = array2 == null ? 0 : array2.length;
        return length1 == length2;
    }

    public static void arrayReverse(Object[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(long[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(int[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(short[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(double[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(float[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(boolean[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void arrayReverse(char[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static int arrayIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.arrayIndexOf(array, objectToFind, 0);
    }

    public static int arrayIndexOf(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int arrayLastIndexOf(Object[] array, Object objectToFind) {
        return ArrayUtil.arrayLastIndexOf(array, objectToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        if (objectToFind == null) {
            for (int i = startIndex; i >= 0; --i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = startIndex; i >= 0; --i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean arrayContains(Object[] array, Object objectToFind) {
        return ArrayUtil.arrayIndexOf(array, objectToFind) != -1;
    }

    public static boolean arrayContains(Object[] array, Object[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(long[] array, long longToFind) {
        return ArrayUtil.arrayIndexOf(array, longToFind, 0);
    }

    public static int arrayIndexOf(long[] array, long[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(long[] array, long longToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (longToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(long[] array, long[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        long first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(long[] array, long longToFind) {
        return ArrayUtil.arrayLastIndexOf(array, longToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(long[] array, long[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(long[] array, long longToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (longToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(long[] array, long[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        long last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(long[] array, long longToFind) {
        return ArrayUtil.arrayIndexOf(array, longToFind) != -1;
    }

    public static boolean arrayContains(long[] array, long[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(int[] array, int intToFind) {
        return ArrayUtil.arrayIndexOf(array, intToFind, 0);
    }

    public static int arrayIndexOf(int[] array, int[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(int[] array, int intToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (intToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(int[] array, int[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(int[] array, int intToFind) {
        return ArrayUtil.arrayLastIndexOf(array, intToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(int[] array, int[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(int[] array, int intToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (intToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(int[] array, int[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        int last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(int[] array, int intToFind) {
        return ArrayUtil.arrayIndexOf(array, intToFind) != -1;
    }

    public static boolean arrayContains(int[] array, int[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(short[] array, short shortToFind) {
        return ArrayUtil.arrayIndexOf(array, shortToFind, 0);
    }

    public static int arrayIndexOf(short[] array, short[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(short[] array, short shortToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (shortToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(short[] array, short[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        short first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(short[] array, short shortToFind) {
        return ArrayUtil.arrayLastIndexOf(array, shortToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(short[] array, short[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(short[] array, short shortToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (shortToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(short[] array, short[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        short last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(short[] array, short shortToFind) {
        return ArrayUtil.arrayIndexOf(array, shortToFind) != -1;
    }

    public static boolean arrayContains(short[] array, short[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(byte[] array, byte byteToFind) {
        return ArrayUtil.arrayIndexOf(array, byteToFind, 0);
    }

    public static int arrayIndexOf(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(byte[] array, byte byteToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (byteToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(byte[] array, byte[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        byte first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(byte[] array, byte byteToFind) {
        return ArrayUtil.arrayLastIndexOf(array, byteToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(byte[] array, byte byteToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (byteToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(byte[] array, byte[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        byte last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(byte[] array, byte byteToFind) {
        return ArrayUtil.arrayIndexOf(array, byteToFind) != -1;
    }

    public static boolean arrayContains(byte[] array, byte[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(double[] array, double doubleToFind) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, 0, 0.0);
    }

    public static int arrayIndexOf(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, 0, tolerance);
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, 0.0);
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, tolerance);
    }

    public static int arrayIndexOf(double[] array, double doubleToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, startIndex, 0.0);
    }

    public static int arrayIndexOf(double[] array, double doubleToFind, int startIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = doubleToFind - tolerance;
        double max = doubleToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, startIndex, 0.0);
    }

    public static int arrayIndexOf(double[] array, double[] arrayToFind, int startIndex, double tolerance) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        double firstMin = arrayToFind[0] - tolerance;
        double firstMax = arrayToFind[0] + tolerance;
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && (array[i] < firstMin || array[i] > firstMax)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                int n = j++;
                int n2 = k++;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind) {
        return ArrayUtil.arrayLastIndexOf(array, doubleToFind, Integer.MAX_VALUE, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, doubleToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, doubleToFind, startIndex, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double doubleToFind, int startIndex, double tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = doubleToFind - tolerance;
        double max = doubleToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, startIndex, 0.0);
    }

    public static int arrayLastIndexOf(double[] array, double[] arrayToFind, int startIndex, double tolerance) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        double lastMin = arrayToFind[lastIndex] - tolerance;
        double lastMax = arrayToFind[lastIndex] + tolerance;
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && (array[i] < lastMin || array[i] > lastMax)) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                int n = j--;
                int n2 = k--;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(double[] array, double doubleToFind) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind) != -1;
    }

    public static boolean arrayContains(double[] array, double doubleToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, doubleToFind, tolerance) != -1;
    }

    public static boolean arrayContains(double[] array, double[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static boolean arrayContains(double[] array, double[] arrayToFind, double tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, tolerance) != -1;
    }

    public static int arrayIndexOf(float[] array, float floatToFind) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, 0, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, 0, tolerance);
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0, tolerance);
    }

    public static int arrayIndexOf(float[] array, float floatToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, startIndex, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float floatToFind, int startIndex, float tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        float min = floatToFind - tolerance;
        float max = floatToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, startIndex, 0.0f);
    }

    public static int arrayIndexOf(float[] array, float[] arrayToFind, int startIndex, float tolerance) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        float firstMin = arrayToFind[0] - tolerance;
        float firstMax = arrayToFind[0] + tolerance;
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && (array[i] < firstMin || array[i] > firstMax)) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                int n = j++;
                int n2 = k++;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind) {
        return ArrayUtil.arrayLastIndexOf(array, floatToFind, Integer.MAX_VALUE, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, floatToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE, tolerance);
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, floatToFind, startIndex, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float floatToFind, int startIndex, float tolerance) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        float min = floatToFind - tolerance;
        float max = floatToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind, int startIndex) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, startIndex, 0.0f);
    }

    public static int arrayLastIndexOf(float[] array, float[] arrayToFind, int startIndex, float tolerance) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        float lastMin = arrayToFind[lastIndex] - tolerance;
        float lastMax = arrayToFind[lastIndex] + tolerance;
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && (array[i] < lastMin || array[i] > lastMax)) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                int n = j--;
                int n2 = k--;
                if (!(Math.abs(array[n] - arrayToFind[n2]) > tolerance)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(float[] array, float floatToFind) {
        return ArrayUtil.arrayIndexOf(array, floatToFind) != -1;
    }

    public static boolean arrayContains(float[] array, float floatToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, floatToFind, tolerance) != -1;
    }

    public static boolean arrayContains(float[] array, float[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static boolean arrayContains(float[] array, float[] arrayToFind, float tolerance) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, tolerance) != -1;
    }

    public static int arrayIndexOf(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.arrayIndexOf(array, booleanToFind, 0);
    }

    public static int arrayIndexOf(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(boolean[] array, boolean booleanToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (booleanToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(boolean[] array, boolean[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        boolean first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.arrayLastIndexOf(array, booleanToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(boolean[] array, boolean booleanToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (booleanToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(boolean[] array, boolean[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        boolean last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(boolean[] array, boolean booleanToFind) {
        return ArrayUtil.arrayIndexOf(array, booleanToFind) != -1;
    }

    public static boolean arrayContains(boolean[] array, boolean[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static int arrayIndexOf(char[] array, char charToFind) {
        return ArrayUtil.arrayIndexOf(array, charToFind, 0);
    }

    public static int arrayIndexOf(char[] array, char[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind, 0);
    }

    public static int arrayIndexOf(char[] array, char charToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (charToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayIndexOf(char[] array, char[] arrayToFind, int startIndex) {
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        if (startIndex >= sourceLength) {
            return targetLength == 0 ? sourceLength : -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        char first = arrayToFind[0];
        int i = startIndex;
        int max = sourceLength - targetLength;
        block0: while (true) {
            if (i <= max && array[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1;
            }
            int j = i + 1;
            int end = j + targetLength - 1;
            int k = 1;
            while (j < end) {
                if (array[j++] == arrayToFind[k++]) continue;
                ++i;
                continue block0;
            }
            break;
        }
        return i;
    }

    public static int arrayLastIndexOf(char[] array, char charToFind) {
        return ArrayUtil.arrayLastIndexOf(array, charToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(char[] array, char[] arrayToFind) {
        return ArrayUtil.arrayLastIndexOf(array, arrayToFind, Integer.MAX_VALUE);
    }

    public static int arrayLastIndexOf(char[] array, char charToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (charToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int arrayLastIndexOf(char[] array, char[] arrayToFind, int startIndex) {
        int start;
        if (array == null || arrayToFind == null) {
            return -1;
        }
        int sourceLength = array.length;
        int targetLength = arrayToFind.length;
        int rightIndex = sourceLength - targetLength;
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex > rightIndex) {
            startIndex = rightIndex;
        }
        if (targetLength == 0) {
            return startIndex;
        }
        int lastIndex = targetLength - 1;
        char last = arrayToFind[lastIndex];
        int min = targetLength - 1;
        int i = min + startIndex;
        block0: while (true) {
            if (i >= min && array[i] != last) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetLength - 1);
            int k = lastIndex - 1;
            while (j > start) {
                if (array[j--] == arrayToFind[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public static boolean arrayContains(char[] array, char charToFind) {
        return ArrayUtil.arrayIndexOf(array, charToFind) != -1;
    }

    public static boolean arrayContains(char[] array, char[] arrayToFind) {
        return ArrayUtil.arrayIndexOf(array, arrayToFind) != -1;
    }

    public static Object[] toArray(Object value) {
        Object[] values;
        if (value == null) {
            return EMPTY_ARRAY;
        }
        if (value.getClass().isArray()) {
            values = (Object[])value;
        } else if (List.class.isInstance(value)) {
            List list = (List)value;
            values = list.toArray();
        } else {
            values = new Object[]{value};
        }
        return values;
    }
}

