/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.emoji.loader.impl;

import com.google.gson.Gson;
import com.whaleal.icefrog.extra.emoji.loader.EmojiDataLoader;
import com.whaleal.icefrog.extra.emoji.model.Emoji;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocalEmojiDataLoader
extends EmojiDataLoader {
    private static final String PATH = "/xxl-tool/emoji/xxl-tool-emoji.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Emoji> loadEmojiData() {
        InputStream stream = null;
        try {
            stream = LocalEmojiDataLoader.class.getResourceAsStream(PATH);
            String emojiJson = LocalEmojiDataLoader.inputStreamToString(stream);
            Gson gson = new Gson();
            List emojiArr = (List)gson.fromJson(emojiJson, List.class);
            if (emojiArr == null || emojiArr.size() == 0) {
                List<Emoji> list = null;
                return list;
            }
            ArrayList<Emoji> emojis = new ArrayList<Emoji>();
            for (Object emojiItem : emojiArr) {
                if (!(emojiItem instanceof Map)) continue;
                Map emojiItemMap = (Map)emojiItem;
                String unicode = String.valueOf(emojiItemMap.get("unicode"));
                List aliases = null;
                if (emojiItemMap.containsKey("aliases") && emojiItemMap.get("aliases") instanceof List) {
                    aliases = (List)emojiItemMap.get("aliases");
                }
                List tags = null;
                if (emojiItemMap.containsKey("tags") && emojiItemMap.get("tags") instanceof List) {
                    tags = (List)emojiItemMap.get("tags");
                }
                boolean supports_fitzpatrick = false;
                if (emojiItemMap.containsKey("supports_fitzpatrick")) {
                    supports_fitzpatrick = Boolean.valueOf(String.valueOf(emojiItemMap.get("supports_fitzpatrick")));
                }
                Emoji emojiObj = new Emoji(unicode, aliases, tags, supports_fitzpatrick);
                emojis.add(emojiObj);
            }
            ArrayList<Emoji> arrayList = emojis;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String inputStreamToString(InputStream stream) throws IOException {
        String read;
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(stream, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        while ((read = br.readLine()) != null) {
            sb.append(read);
        }
        br.close();
        return sb.toString();
    }
}

