/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.jwt;

import com.whaleal.icefrog.core.codec.Base64;
import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.date.DateUtil;
import com.whaleal.icefrog.core.exceptions.ValidateException;
import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.json.JSONObject;
import com.whaleal.icefrog.jwt.JWTException;
import com.whaleal.icefrog.jwt.JWTHeader;
import com.whaleal.icefrog.jwt.JWTPayload;
import com.whaleal.icefrog.jwt.JWTValidator;
import com.whaleal.icefrog.jwt.RegisteredPayload;
import com.whaleal.icefrog.jwt.signers.AlgorithmUtil;
import com.whaleal.icefrog.jwt.signers.JWTSigner;
import com.whaleal.icefrog.jwt.signers.JWTSignerUtil;
import com.whaleal.icefrog.jwt.signers.NoneJWTSigner;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.util.List;
import java.util.Map;

public class JWT
implements RegisteredPayload<JWT> {
    private final JWTHeader header = new JWTHeader();
    private final JWTPayload payload = new JWTPayload();
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private JWTSigner signer;
    private List<String> tokens;

    public static JWT create() {
        return new JWT();
    }

    public static JWT of(String token) {
        return new JWT(token);
    }

    public JWT() {
    }

    public JWT(String token) {
        this();
        this.parse(token);
    }

    public JWT parse(String token) {
        List<String> tokens = JWT.splitToken(token);
        this.tokens = tokens;
        this.header.parse(tokens.get(0), this.charset);
        this.payload.parse(tokens.get(1), this.charset);
        return this;
    }

    public JWT setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JWT setKey(byte[] key) {
        return this.setSigner(JWTSignerUtil.hs256(key));
    }

    public JWT setSigner(String algorithmId, byte[] key) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, Key key) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, key));
    }

    public JWT setSigner(String algorithmId, KeyPair keyPair) {
        return this.setSigner(JWTSignerUtil.createSigner(algorithmId, keyPair));
    }

    public JWT setSigner(JWTSigner signer) {
        this.signer = signer;
        return this;
    }

    public JWTSigner getSigner() {
        return this.signer;
    }

    public JSONObject getHeaders() {
        return this.header.getClaimsJson();
    }

    public JWTHeader getHeader() {
        return this.header;
    }

    public Object getHeader(String name) {
        return this.header.getClaim(name);
    }

    public String getAlgorithm() {
        return (String)this.header.getClaim(JWTHeader.ALGORITHM);
    }

    public JWT setHeader(String name, Object value) {
        this.header.setClaim(name, value);
        return this;
    }

    public JWT addHeaders(Map<String, ?> headers) {
        this.header.addHeaders(headers);
        return this;
    }

    public JSONObject getPayloads() {
        return this.payload.getClaimsJson();
    }

    public JWTPayload getPayload() {
        return this.payload;
    }

    public Object getPayload(String name) {
        return this.getPayload().getClaim(name);
    }

    @Override
    public JWT setPayload(String name, Object value) {
        this.payload.setClaim(name, value);
        return this;
    }

    public JWT addPayloads(Map<String, ?> payloads) {
        this.payload.addPayloads(payloads);
        return this;
    }

    public String sign() {
        return this.sign(this.signer);
    }

    public String sign(JWTSigner signer) {
        Assert.notNull(signer, () -> new JWTException("No Signer provided!"));
        String claim = (String)this.header.getClaim(JWTHeader.ALGORITHM);
        if (StrUtil.isBlank(claim)) {
            this.header.setClaim(JWTHeader.ALGORITHM, AlgorithmUtil.getId(signer.getAlgorithm()));
        }
        String headerBase64 = Base64.encodeUrlSafe((CharSequence)this.header.toString(), this.charset);
        String payloadBase64 = Base64.encodeUrlSafe((CharSequence)this.payload.toString(), this.charset);
        String sign = signer.sign(headerBase64, payloadBase64);
        return StrUtil.format("{}.{}.{}", headerBase64, payloadBase64, sign);
    }

    public boolean verify() {
        return this.verify(this.signer);
    }

    public boolean validate(long leeway) {
        if (!this.verify()) {
            return false;
        }
        try {
            JWTValidator.of(this).validateDate(DateUtil.date(), leeway);
        }
        catch (ValidateException e) {
            return false;
        }
        return true;
    }

    public boolean verify(JWTSigner signer) {
        List<String> tokens;
        if (null == signer) {
            signer = NoneJWTSigner.NONE;
        }
        if (CollUtil.isEmpty(tokens = this.tokens)) {
            throw new JWTException("No token to verify!");
        }
        return signer.verify(tokens.get(0), tokens.get(1), tokens.get(2));
    }

    private static List<String> splitToken(String token) {
        List<String> tokens = StrUtil.split((CharSequence)token, '.');
        if (3 != tokens.size()) {
            throw new JWTException("The token was expected 3 parts, but got {}.", tokens.size());
        }
        return tokens;
    }
}

