/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.jwt.signers;

import com.whaleal.icefrog.core.codec.Base64;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.crypto.asymmetric.Sign;
import com.whaleal.icefrog.jwt.signers.JWTSigner;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class AsymmetricJWTSigner
implements JWTSigner {
    private Charset charset = CharsetUtil.CHARSET_UTF_8;
    private final Sign sign;

    public AsymmetricJWTSigner(String algorithm, Key key) {
        PublicKey publicKey = key instanceof PublicKey ? (PublicKey)key : null;
        PrivateKey privateKey = key instanceof PrivateKey ? (PrivateKey)key : null;
        this.sign = new Sign(algorithm, privateKey, publicKey);
    }

    public AsymmetricJWTSigner(String algorithm, KeyPair keyPair) {
        this.sign = new Sign(algorithm, keyPair);
    }

    public AsymmetricJWTSigner setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public String sign(String headerBase64, String payloadBase64) {
        return Base64.encodeUrlSafe(this.sign.sign(StrUtil.format("{}.{}", headerBase64, payloadBase64)));
    }

    @Override
    public boolean verify(String headerBase64, String payloadBase64, String signBase64) {
        return this.sign.verify(StrUtil.bytes((CharSequence)StrUtil.format("{}.{}", headerBase64, payloadBase64), this.charset), Base64.decode(signBase64));
    }

    @Override
    public String getAlgorithm() {
        return this.sign.getSignature().getAlgorithm();
    }
}

