/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.jwt.signers;

import com.whaleal.icefrog.core.lang.Assert;
import com.whaleal.icefrog.jwt.signers.AlgorithmUtil;
import com.whaleal.icefrog.jwt.signers.AsymmetricJWTSigner;
import com.whaleal.icefrog.jwt.signers.HMacJWTSigner;
import com.whaleal.icefrog.jwt.signers.JWTSigner;
import com.whaleal.icefrog.jwt.signers.NoneJWTSigner;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class JWTSignerUtil {
    public static JWTSigner none() {
        return NoneJWTSigner.NONE;
    }

    public static JWTSigner hs256(byte[] key) {
        return JWTSignerUtil.createSigner("HS256", key);
    }

    public static JWTSigner hs384(byte[] key) {
        return JWTSignerUtil.createSigner("HS384", key);
    }

    public static JWTSigner hs512(byte[] key) {
        return JWTSignerUtil.createSigner("HS512", key);
    }

    public static JWTSigner rs256(Key key) {
        return JWTSignerUtil.createSigner("RS256", key);
    }

    public static JWTSigner rs384(Key key) {
        return JWTSignerUtil.createSigner("RS384", key);
    }

    public static JWTSigner rs512(Key key) {
        return JWTSignerUtil.createSigner("RS512", key);
    }

    public static JWTSigner es256(Key key) {
        return JWTSignerUtil.createSigner("ES256", key);
    }

    public static JWTSigner es384(Key key) {
        return JWTSignerUtil.createSigner("ES384", key);
    }

    public static JWTSigner es512(Key key) {
        return JWTSignerUtil.createSigner("ES512", key);
    }

    public static JWTSigner createSigner(String algorithmId, byte[] key) {
        Assert.notNull(key, "Signer key must be not null!", new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return JWTSignerUtil.none();
        }
        return new HMacJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
    }

    public static JWTSigner createSigner(String algorithmId, KeyPair keyPair) {
        Assert.notNull(keyPair, "Signer key pair must be not null!", new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return JWTSignerUtil.none();
        }
        return new AsymmetricJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), keyPair);
    }

    public static JWTSigner createSigner(String algorithmId, Key key) {
        Assert.notNull(key, "Signer key must be not null!", new Object[0]);
        if (null == algorithmId || "none".equals(algorithmId)) {
            return NoneJWTSigner.NONE;
        }
        if (key instanceof PrivateKey || key instanceof PublicKey) {
            return new AsymmetricJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
        }
        return new HMacJWTSigner(AlgorithmUtil.getAlgorithm(algorithmId), key);
    }
}

