/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.crypto.asymmetric;

import com.whaleal.icefrog.core.codec.BCD;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.crypto.SecureUtil;
import com.whaleal.icefrog.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface AsymmetricDecryptor {
    public byte[] decrypt(byte[] var1, KeyType var2);

    default public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes(data), keyType);
    }

    default public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(SecureUtil.decode(data), keyType);
    }

    default public String decryptStr(String data, KeyType keyType, Charset charset) {
        return StrUtil.str(this.decrypt(data, keyType), charset);
    }

    default public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        Preconditions.notNull(data, "Bcd string must be not null!", new Object[0]);
        byte[] dataBytes = BCD.ascToBcd(StrUtil.bytes((CharSequence)data, charset));
        return this.decrypt(dataBytes, keyType);
    }

    default public String decryptStrFromBcd(String data, KeyType keyType, Charset charset) {
        return StrUtil.str(this.decryptFromBcd(data, keyType, charset), charset);
    }

    default public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }
}

