/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.dialect.impl;

import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.DbRuntimeException;
import com.whaleal.icefrog.db.Entity;
import com.whaleal.icefrog.db.Page;
import com.whaleal.icefrog.db.StatementUtil;
import com.whaleal.icefrog.db.dialect.Dialect;
import com.whaleal.icefrog.db.dialect.DialectName;
import com.whaleal.icefrog.db.sql.Condition;
import com.whaleal.icefrog.db.sql.Query;
import com.whaleal.icefrog.db.sql.SqlBuilder;
import com.whaleal.icefrog.db.sql.Wrapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class AnsiSqlDialect
implements Dialect {
    private static final long serialVersionUID = 2088101129774974580L;
    protected Wrapper wrapper = new Wrapper();

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entity, this.dialectName());
        return StatementUtil.prepareStatement(conn, insert);
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, Entity ... entities) throws SQLException {
        if (ArrayUtil.isEmpty(entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entities[0], this.dialectName());
        return StatementUtil.prepareStatementForBatch(conn, insert.build(), insert.getFields(), entities);
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Query query) throws SQLException {
        Preconditions.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.create(this.wrapper).delete(query.getFirstTableName()).where(where);
        return StatementUtil.prepareStatement(conn, delete);
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Query query) throws SQLException {
        Preconditions.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepare statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where(where);
        return StatementUtil.prepareStatement(conn, update);
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Query query) throws SQLException {
        return this.psForPage(conn, query);
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        Preconditions.notNull(query, "query must be not null !", new Object[0]);
        if (StrUtil.hasBlank(query.getTableNames())) {
            throw new DbRuntimeException("Table name must be not empty !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query);
        return this.psForPage(conn, find, query.getPage());
    }

    @Override
    public PreparedStatement psForPage(Connection conn, SqlBuilder sqlBuilder, Page page) throws SQLException {
        if (null != page) {
            sqlBuilder = this.wrapPageSql(sqlBuilder.orderBy(page.getOrders()), page);
        }
        return StatementUtil.prepareStatement(conn, sqlBuilder);
    }

    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getPageSize()).append(" offset ").append(page.getStartPosition());
    }

    @Override
    public String dialectName() {
        return DialectName.ANSI.name();
    }
}

