/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.sql;

import com.whaleal.icefrog.core.builder.Builder;
import com.whaleal.icefrog.core.collection.ListUtil;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.db.sql.Condition;
import java.util.ArrayList;
import java.util.List;

public class ConditionBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private final Condition[] conditions;
    private List<Object> paramValues;

    public static ConditionBuilder of(Condition ... conditions) {
        return new ConditionBuilder(conditions);
    }

    public ConditionBuilder(Condition ... conditions) {
        this.conditions = conditions;
    }

    public List<Object> getParamValues() {
        return ListUtil.unmodifiable(this.paramValues);
    }

    @Override
    public String build() {
        if (null == this.paramValues) {
            this.paramValues = new ArrayList<Object>();
        } else {
            this.paramValues.clear();
        }
        return this.build(this.paramValues);
    }

    public String build(List<Object> paramValues) {
        if (ArrayUtil.isEmpty(this.conditions)) {
            return "";
        }
        StringBuilder conditionStrBuilder = new StringBuilder();
        boolean isFirst = true;
        for (Condition condition : this.conditions) {
            if (isFirst) {
                isFirst = false;
            } else {
                conditionStrBuilder.append(' ').append((Object)condition.getLinkOperator()).append(' ');
            }
            conditionStrBuilder.append(condition.toString(paramValues));
        }
        return conditionStrBuilder.toString();
    }

    public String toString() {
        return this.build();
    }
}

