/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.compress.archiver;

import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.lang.Filter;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.compress.CompressException;
import com.whaleal.icefrog.extra.compress.archiver.Archiver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class StreamArchiver
implements Archiver {
    private final ArchiveOutputStream out;

    public static StreamArchiver create(Charset charset, String archiverName, File file) {
        return new StreamArchiver(charset, archiverName, file);
    }

    public static StreamArchiver create(Charset charset, String archiverName, OutputStream out) {
        return new StreamArchiver(charset, archiverName, out);
    }

    public StreamArchiver(Charset charset, String archiverName, File file) {
        this(charset, archiverName, FileUtil.getOutputStream(file));
    }

    public StreamArchiver(Charset charset, String archiverName, OutputStream targetStream) {
        ArchiveStreamFactory factory = new ArchiveStreamFactory(charset.name());
        try {
            this.out = factory.createArchiveOutputStream(archiverName, targetStream);
        }
        catch (ArchiveException e) {
            throw new CompressException(e);
        }
        if (this.out instanceof TarArchiveOutputStream) {
            ((TarArchiveOutputStream)this.out).setLongFileMode(2);
        } else if (this.out instanceof ArArchiveOutputStream) {
            ((ArArchiveOutputStream)this.out).setLongFileMode(1);
        }
    }

    @Override
    public StreamArchiver add(File file, String path, Filter<File> filter) throws IORuntimeException {
        try {
            this.addInternal(file, path, filter);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public StreamArchiver finish() {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        IoUtil.close((Closeable)this.out);
    }

    private void addInternal(File file, String path, Filter<File> filter) throws IOException {
        if (null != filter && !filter.accept(file)) {
            return;
        }
        ArchiveOutputStream out = this.out;
        String entryName = StrUtil.addSuffixIfNot(StrUtil.nullToEmpty(path), "/") + file.getName();
        out.putArchiveEntry(out.createArchiveEntry(file, entryName));
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = file.listFiles()) {
                this.addInternal(childFile, entryName, filter);
            }
        } else {
            if (file.isFile()) {
                FileUtil.writeToStream(file, (OutputStream)out);
            }
            out.closeArchiveEntry();
        }
    }
}

