/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.emoji;

import com.whaleal.icefrog.extra.emoji.encode.EmojiEncode;
import com.whaleal.icefrog.extra.emoji.factory.EmojiFactory;
import com.whaleal.icefrog.extra.emoji.fitzpatrick.FitzpatrickAction;
import com.whaleal.icefrog.extra.emoji.model.AliasCandidate;
import com.whaleal.icefrog.extra.emoji.model.Emoji;
import com.whaleal.icefrog.extra.emoji.model.UnicodeCandidate;
import com.whaleal.icefrog.extra.emoji.transformer.EmojiTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EmojiTool {
    private static String encodeUnicode(String input, EmojiTransformer transformer, FitzpatrickAction fitzpatrickAction) {
        int prev = 0;
        StringBuilder sb = new StringBuilder();
        List<UnicodeCandidate> replacements = EmojiFactory.getUnicodeCandidates(input);
        for (UnicodeCandidate candidate : replacements) {
            sb.append(input.substring(prev, candidate.getEmojiStartIndex()));
            sb.append(transformer.transform(candidate, fitzpatrickAction));
            prev = candidate.getFitzpatrickEndIndex();
        }
        return sb.append(input.substring(prev)).toString();
    }

    public static String encodeUnicode(String input, EmojiEncode emojiEncode, FitzpatrickAction fitzpatrickAction) {
        if (emojiEncode == null) {
            emojiEncode = EmojiEncode.ALIASES;
        }
        if (fitzpatrickAction == null) {
            fitzpatrickAction = FitzpatrickAction.PARSE;
        }
        return EmojiTool.encodeUnicode(input, emojiEncode.getEmojiTransformer(), fitzpatrickAction);
    }

    public static String encodeUnicode(String input, EmojiEncode emojiEncode) {
        return EmojiTool.encodeUnicode(input, emojiEncode, FitzpatrickAction.PARSE);
    }

    public static String encodeUnicode(String input) {
        return EmojiTool.encodeUnicode(input, EmojiEncode.ALIASES);
    }

    public static String decodeToUnicode(String input, EmojiEncode emojiEncode) {
        String result = input;
        if (emojiEncode == null || emojiEncode == EmojiEncode.ALIASES) {
            List<AliasCandidate> candidates = EmojiFactory.getAliasCandidates(input);
            for (AliasCandidate candidate : candidates) {
                Emoji emoji = EmojiFactory.getForAlias(candidate.alias);
                if (emoji == null || !emoji.supportsFitzpatrick() && (emoji.supportsFitzpatrick() || candidate.fitzpatrick != null)) continue;
                String replacement = emoji.getUnicode();
                if (candidate.fitzpatrick != null) {
                    replacement = replacement + candidate.fitzpatrick.unicode;
                }
                result = result.replace(":" + candidate.fullString + ":", replacement);
            }
        }
        for (Emoji emoji : EmojiFactory.getAll()) {
            if (emojiEncode == null || emojiEncode == EmojiEncode.HTML_DECIMAL) {
                result = result.replace(emoji.getHtmlDecimal(), emoji.getUnicode());
            }
            if (emojiEncode != null && emojiEncode != EmojiEncode.HTML_HEX_DECIMAL) continue;
            result = result.replace(emoji.getHtmlHexadecimal(), emoji.getUnicode());
        }
        return result;
    }

    public static String decodeToUnicode(String input) {
        return EmojiTool.decodeToUnicode(input, null);
    }

    public static String removeEmojis(String input, final Collection<Emoji> emojisToRemove, final Collection<Emoji> emojisToKeep) {
        EmojiTransformer emojiTransformer = new EmojiTransformer(){

            @Override
            public String transform(UnicodeCandidate unicodeCandidate, FitzpatrickAction fitzpatrickAction) {
                boolean ifDelete = true;
                if (emojisToRemove != null && emojisToRemove.size() > 0 && emojisToRemove.contains(unicodeCandidate.getEmoji())) {
                    ifDelete = true;
                }
                if (emojisToKeep != null && emojisToKeep.size() > 0 && emojisToKeep.contains(unicodeCandidate.getEmoji())) {
                    ifDelete = false;
                }
                if (ifDelete) {
                    return "";
                }
                return unicodeCandidate.getEmoji().getUnicode() + unicodeCandidate.getFitzpatrickUnicode();
            }
        };
        return EmojiTool.encodeUnicode(input, emojiTransformer, null);
    }

    public static List<String> findEmojis(String input) {
        List<UnicodeCandidate> emojis = EmojiFactory.getUnicodeCandidates(input);
        ArrayList<String> result = new ArrayList<String>();
        for (UnicodeCandidate emoji : emojis) {
            result.add(emoji.getEmoji().getUnicode());
        }
        return result;
    }

    public static boolean isEmoji(String unicode) {
        Emoji emoji = EmojiFactory.getByUnicode(unicode);
        return emoji != null;
    }
}

