/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.http;

import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.io.FastByteArrayOutputStream;
import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.io.StreamProgress;
import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.ReUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.core.util.URLUtil;
import com.whaleal.icefrog.http.Header;
import com.whaleal.icefrog.http.HttpBase;
import com.whaleal.icefrog.http.HttpConnection;
import com.whaleal.icefrog.http.HttpException;
import com.whaleal.icefrog.http.HttpInputStream;
import com.whaleal.icefrog.http.HttpUtil;
import com.whaleal.icefrog.http.cookie.GlobalCookieManager;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpCookie;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpResponse
extends HttpBase<HttpResponse>
implements Closeable {
    protected HttpConnection httpConnection;
    protected InputStream in;
    private volatile boolean isAsync;
    protected int status;
    private final boolean ignoreBody;
    private Charset charsetFromResponse;

    protected HttpResponse(HttpConnection httpConnection, Charset charset, boolean isAsync, boolean isIgnoreBody) {
        this.httpConnection = httpConnection;
        this.charset = charset;
        this.isAsync = isAsync;
        this.ignoreBody = isIgnoreBody;
        this.initWithDisconnect();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isOk() {
        return this.status >= 200 && this.status < 300;
    }

    public HttpResponse sync() {
        return this.isAsync ? this.forceSync() : this;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public long contentLength() {
        long contentLength = Convert.toLong(this.header(Header.CONTENT_LENGTH), -1L);
        if (contentLength > 0L && (this.isChunked() || StrUtil.isNotBlank(this.contentEncoding()))) {
            contentLength = -1L;
        }
        return contentLength;
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return "gzip".equalsIgnoreCase(contentEncoding);
    }

    public boolean isDeflate() {
        String contentEncoding = this.contentEncoding();
        return "deflate".equalsIgnoreCase(contentEncoding);
    }

    public boolean isChunked() {
        String transferEncoding = this.header(Header.TRANSFER_ENCODING);
        return "Chunked".equalsIgnoreCase(transferEncoding);
    }

    public String getCookieStr() {
        return this.header(Header.SET_COOKIE);
    }

    public List<HttpCookie> getCookies() {
        return GlobalCookieManager.getCookies(this.httpConnection);
    }

    public HttpCookie getCookie(String name) {
        List<HttpCookie> cookie = this.getCookies();
        if (null != cookie) {
            for (HttpCookie httpCookie : cookie) {
                if (!httpCookie.getName().equals(name)) continue;
                return httpCookie;
            }
        }
        return null;
    }

    public String getCookieValue(String name) {
        HttpCookie cookie = this.getCookie(name);
        return null == cookie ? null : cookie.getValue();
    }

    public InputStream bodyStream() {
        if (this.isAsync) {
            return this.in;
        }
        return new ByteArrayInputStream(this.bodyBytes);
    }

    public byte[] bodyBytes() {
        this.sync();
        return this.bodyBytes;
    }

    public String body() throws HttpException {
        return HttpUtil.getString(this.bodyBytes(), this.charset, null == this.charsetFromResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeBody(OutputStream out, boolean isCloseOut, StreamProgress streamProgress) {
        Preconditions.notNull(out, "[out] must be not null!", new Object[0]);
        long contentLength = this.contentLength();
        try {
            long l = HttpResponse.copyBody(this.bodyStream(), out, contentLength, streamProgress);
            return l;
        }
        finally {
            IoUtil.close(this);
            if (isCloseOut) {
                IoUtil.close(out);
            }
        }
    }

    public long writeBody(File targetFileOrDir, StreamProgress streamProgress) {
        Preconditions.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        return this.writeBody(FileUtil.getOutputStream(outFile), true, streamProgress);
    }

    public long writeBody(File targetFileOrDir, String tempFileSuffix, StreamProgress streamProgress) {
        long length;
        Preconditions.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        tempFileSuffix = StrUtil.isBlank(tempFileSuffix) ? ".temp" : StrUtil.addPrefixIfNot(tempFileSuffix, ".");
        String fileName = outFile.getName();
        String tempFileName = fileName + tempFileSuffix;
        outFile = new File(outFile.getParentFile(), tempFileName);
        try {
            length = this.writeBody(outFile, streamProgress);
            FileUtil.rename(outFile, fileName, true);
        }
        catch (Throwable e) {
            FileUtil.del(outFile);
            throw new HttpException(e);
        }
        return length;
    }

    public File writeBodyForFile(File targetFileOrDir, StreamProgress streamProgress) {
        Preconditions.notNull(targetFileOrDir, "[targetFileOrDir] must be not null!", new Object[0]);
        File outFile = this.completeFileNameFromHeader(targetFileOrDir);
        this.writeBody(FileUtil.getOutputStream(outFile), true, streamProgress);
        return outFile;
    }

    public long writeBody(File targetFileOrDir) {
        return this.writeBody(targetFileOrDir, null);
    }

    public long writeBody(String targetFileOrDir) {
        return this.writeBody(FileUtil.file(targetFileOrDir));
    }

    @Override
    public void close() {
        IoUtil.close(this.in);
        this.in = null;
        this.httpConnection.disconnectQuietly();
    }

    @Override
    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Response Headers: ").append("\r\n");
        for (Map.Entry entry : this.headers.entrySet()) {
            sb.append("    ").append(entry).append("\r\n");
        }
        sb.append("Response Body: ").append("\r\n");
        sb.append("    ").append(this.body()).append("\r\n");
        return sb.toString();
    }

    public File completeFileNameFromHeader(File targetFileOrDir) {
        String path;
        if (!targetFileOrDir.isDirectory()) {
            return targetFileOrDir;
        }
        String fileName = this.getFileNameFromDisposition();
        if (StrUtil.isBlank(fileName) && StrUtil.isBlank(fileName = StrUtil.subSuf(path = this.httpConnection.getUrl().getPath(), path.lastIndexOf(47) + 1))) {
            fileName = URLUtil.encodeQuery(path, CharsetUtil.CHARSET_UTF_8);
        }
        return FileUtil.file(targetFileOrDir, fileName);
    }

    private HttpResponse initWithDisconnect() throws HttpException {
        try {
            this.init();
        }
        catch (HttpException e) {
            this.httpConnection.disconnectQuietly();
            throw e;
        }
        return this;
    }

    private HttpResponse init() throws HttpException {
        Charset charset;
        block5: {
            try {
                this.status = this.httpConnection.responseCode();
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block5;
                throw new HttpException(e);
            }
        }
        try {
            this.headers = this.httpConnection.headers();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        GlobalCookieManager.store(this.httpConnection);
        this.charsetFromResponse = charset = this.httpConnection.getCharset();
        if (null != charset) {
            this.charset = charset;
        }
        this.in = new HttpInputStream(this);
        return this.isAsync ? this : this.forceSync();
    }

    private HttpResponse forceSync() {
        block7: {
            try {
                this.readBody(this.in);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof FileNotFoundException) {
                    break block7;
                }
                throw new HttpException(e);
            }
            finally {
                if (this.isAsync) {
                    this.isAsync = false;
                }
                this.close();
            }
        }
        return this;
    }

    private void readBody(InputStream in) throws IORuntimeException {
        if (this.ignoreBody) {
            return;
        }
        long contentLength = this.contentLength();
        FastByteArrayOutputStream out = new FastByteArrayOutputStream((int)contentLength);
        HttpResponse.copyBody(in, out, contentLength, null);
        this.bodyBytes = out.toByteArray();
    }

    private static long copyBody(InputStream in, OutputStream out, long contentLength, StreamProgress streamProgress) {
        long copyLength;
        block3: {
            if (null == out) {
                throw new NullPointerException("[out] is null!");
            }
            copyLength = -1L;
            try {
                copyLength = IoUtil.copy(in, out, 8192, contentLength, streamProgress);
            }
            catch (IORuntimeException e) {
                if (e.getCause() instanceof EOFException || StrUtil.containsIgnoreCase(e.getMessage(), "Premature EOF")) break block3;
                throw e;
            }
        }
        return copyLength;
    }

    private String getFileNameFromDisposition() {
        String fileName = null;
        String disposition = this.header(Header.CONTENT_DISPOSITION);
        if (StrUtil.isNotBlank(disposition) && StrUtil.isBlank(fileName = ReUtil.get("filename=\"(.*?)\"", (CharSequence)disposition, 1))) {
            fileName = StrUtil.subAfter((CharSequence)disposition, "filename=", true);
        }
        return fileName;
    }
}

