/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.json;

import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.convert.ConvertException;
import com.whaleal.icefrog.core.date.DateUtil;
import com.whaleal.icefrog.core.date.LocalDateTimeUtil;
import com.whaleal.icefrog.core.getter.OptNullBasicTypeFromObjectGetter;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.json.JSON;
import com.whaleal.icefrog.json.JSONArray;
import com.whaleal.icefrog.json.JSONConfig;
import com.whaleal.icefrog.json.JSONConverter;
import com.whaleal.icefrog.json.JSONNull;
import com.whaleal.icefrog.json.JSONObject;
import com.whaleal.icefrog.json.JSONUtil;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;

public interface JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    public JSONConfig getConfig();

    default public boolean isNull(K key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    default public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    default public String getStrEscaped(K key, String defaultValue) {
        return JSONUtil.escape(this.getStr(key, defaultValue));
    }

    default public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONArray)object;
        }
        return new JSONArray(object, this.getConfig());
    }

    default public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSON) {
            return (JSONObject)object;
        }
        return new JSONObject(object, this.getConfig());
    }

    default public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return null == obj ? null : (T)obj.toBean(beanType);
    }

    @Override
    default public Date getDate(K key, Date defaultValue) {
        String format;
        Object obj = this.getObj(key);
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        Optional<String> formatOps = Optional.ofNullable(this.getConfig()).map(JSONConfig::getDateFormat);
        if (formatOps.isPresent() && StrUtil.isNotBlank(format = formatOps.get())) {
            String str = Convert.toStr(obj);
            if (null == str) {
                return defaultValue;
            }
            return DateUtil.parse((CharSequence)str, format);
        }
        return Convert.toDate(obj, defaultValue);
    }

    default public LocalDateTime getLocalDateTime(K key, LocalDateTime defaultValue) {
        String format;
        Object obj = this.getObj(key);
        if (null == obj) {
            return defaultValue;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        Optional<String> formatOps = Optional.ofNullable(this.getConfig()).map(JSONConfig::getDateFormat);
        if (formatOps.isPresent() && StrUtil.isNotBlank(format = formatOps.get())) {
            String str = Convert.toStr(obj);
            if (null == str) {
                return defaultValue;
            }
            return LocalDateTimeUtil.parse((CharSequence)str, format);
        }
        return Convert.toLocalDateTime(obj, defaultValue);
    }

    default public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    default public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return JSONConverter.jsonConvert(type, value, ignoreError);
    }
}

