/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang.loader;

import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.lang.loader.LazyLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LazyFunLoader<T>
extends LazyLoader<T> {
    private static final long serialVersionUID = 1L;
    private Supplier<T> supplier;

    public LazyFunLoader(Supplier<T> supplier) {
        Preconditions.notNull(supplier);
        this.supplier = supplier;
    }

    @Override
    protected T init() {
        T t = this.supplier.get();
        this.supplier = null;
        return t;
    }

    public boolean isInitialize() {
        return this.supplier == null;
    }

    public void ifInitialized(Consumer<T> consumer) {
        Preconditions.notNull(consumer);
        if (this.isInitialize()) {
            consumer.accept(this.get());
        }
    }
}

