/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.ds.pooled;

import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.ds.AbstractDSFactory;
import com.whaleal.icefrog.db.ds.pooled.DbConfig;
import com.whaleal.icefrog.db.ds.pooled.PooledDataSource;
import com.whaleal.icefrog.setting.Setting;
import javax.sql.DataSource;

public class PooledDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 8093886210895248277L;
    public static final String DS_NAME = "icefrog-Pooled-DataSource";

    public PooledDSFactory() {
        this((Setting)null);
    }

    public PooledDSFactory(Setting setting) {
        super(DS_NAME, PooledDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        DbConfig dbConfig = new DbConfig();
        dbConfig.setUrl(jdbcUrl);
        dbConfig.setDriver(driver);
        dbConfig.setUser(user);
        dbConfig.setPass(pass);
        dbConfig.setInitialSize(poolSetting.getInt("initialSize", 0));
        dbConfig.setMinIdle(poolSetting.getInt("minIdle", 0));
        dbConfig.setMaxActive(poolSetting.getInt("maxActive", 8));
        dbConfig.setMaxWait(poolSetting.getLong("maxWait", 6000L));
        for (String key : KEY_CONN_PROPS) {
            String connValue = poolSetting.get(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        return new PooledDataSource(dbConfig);
    }
}

