/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.sql;

import com.whaleal.icefrog.db.sql.SqlFormatter;
import com.whaleal.icefrog.log.Log;
import com.whaleal.icefrog.log.LogFactory;
import com.whaleal.icefrog.log.level.Level;

public enum SqlLog {
    INSTANCE;

    public static final String KEY_SHOW_SQL = "showSql";
    public static final String KEY_FORMAT_SQL = "formatSql";
    public static final String KEY_SHOW_PARAMS = "showParams";
    public static final String KEY_SQL_LEVEL = "sqlLevel";
    private static final Log log;
    private boolean showSql;
    private boolean formatSql;
    private boolean showParams;
    private Level level = Level.DEBUG;

    public void init(boolean isShowSql, boolean isFormatSql, boolean isShowParams, Level level) {
        this.showSql = isShowSql;
        this.formatSql = isFormatSql;
        this.showParams = isShowParams;
        this.level = level;
    }

    public void log(String sql) {
        this.log(sql, null);
    }

    public void logForBatch(String sql) {
        if (this.showSql) {
            log.log(this.level, "\n[Batch SQL] -> {}", this.formatSql ? SqlFormatter.format(sql) : sql);
        }
    }

    public void log(String sql, Object paramValues) {
        if (this.showSql) {
            if (null != paramValues && this.showParams) {
                log.log(this.level, "\n[SQL] -> {}\nParams -> {}", this.formatSql ? SqlFormatter.format(sql) : sql, paramValues);
            } else {
                log.log(this.level, "\n[SQL] -> {}", this.formatSql ? SqlFormatter.format(sql) : sql);
            }
        }
    }

    static {
        log = LogFactory.get();
    }
}

