/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.emoji.model;

import com.whaleal.icefrog.extra.emoji.fitzpatrick.Fitzpatrick;
import com.whaleal.icefrog.extra.emoji.model.Emoji;

public class UnicodeCandidate {
    private final Emoji emoji;
    private final Fitzpatrick fitzpatrick;
    private final int startIndex;

    public UnicodeCandidate(Emoji emoji, String fitzpatrick, int startIndex) {
        this.emoji = emoji;
        this.fitzpatrick = Fitzpatrick.fitzpatrickFromUnicode(fitzpatrick);
        this.startIndex = startIndex;
    }

    public Emoji getEmoji() {
        return this.emoji;
    }

    public boolean hasFitzpatrick() {
        return this.getFitzpatrick() != null;
    }

    public Fitzpatrick getFitzpatrick() {
        return this.fitzpatrick;
    }

    public String getFitzpatrickType() {
        return this.hasFitzpatrick() ? this.fitzpatrick.name().toLowerCase() : "";
    }

    public String getFitzpatrickUnicode() {
        return this.hasFitzpatrick() ? this.fitzpatrick.unicode : "";
    }

    public int getEmojiStartIndex() {
        return this.startIndex;
    }

    public int getEmojiEndIndex() {
        return this.startIndex + this.emoji.getUnicode().length();
    }

    public int getFitzpatrickEndIndex() {
        return this.getEmojiEndIndex() + (this.fitzpatrick != null ? 2 : 0);
    }
}

