/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.poi.excel;

import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;

public class ExcelDateUtil {
    private static final int[] customFormats = new int[]{28, 30, 31, 32, 33, 55, 56, 57, 58};

    public static boolean isDateFormat(Cell cell) {
        return ExcelDateUtil.isDateFormat(cell, null);
    }

    public static boolean isDateFormat(Cell cell, ConditionalFormattingEvaluator cfEvaluator) {
        ExcelNumberFormat nf = ExcelNumberFormat.from((Cell)cell, (ConditionalFormattingEvaluator)cfEvaluator);
        return ExcelDateUtil.isDateFormat(nf);
    }

    public static boolean isDateFormat(ExcelNumberFormat numFmt) {
        return ExcelDateUtil.isDateFormat(numFmt.getIdx(), numFmt.getFormat());
    }

    public static boolean isDateFormat(int formatIndex, String formatString) {
        if (ArrayUtil.contains(customFormats, formatIndex)) {
            return true;
        }
        if (StrUtil.isNotEmpty(formatString) && StrUtil.containsAny((CharSequence)formatString, "\u5468", "\u661f\u671f", "aa")) {
            return true;
        }
        return DateUtil.isADateFormat((int)formatIndex, (String)formatString);
    }
}

