/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.setting.dialect;

import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.resource.NoResourceException;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.setting.dialect.Props;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PropsUtil {
    private static final Map<String, Props> propsMap = new ConcurrentHashMap<String, Props>();

    public static Props get(String name) {
        return propsMap.computeIfAbsent(name, filePath -> {
            String extName = FileUtil.extName(filePath);
            if (StrUtil.isEmpty(extName)) {
                filePath = filePath + "." + "properties";
            }
            return new Props((String)filePath);
        });
    }

    public static Props getFirstFound(String ... names) {
        for (String name : names) {
            try {
                return PropsUtil.get(name);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }

    public static Props getSystemProps() {
        return new Props(System.getProperties());
    }
}

