/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.io.copy;

import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.StreamProgress;
import com.whaleal.icefrog.core.io.copy.IoCopier;
import com.whaleal.icefrog.core.lang.Preconditions;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

public class ReaderWriterCopier
extends IoCopier<Reader, Writer> {
    public ReaderWriterCopier() {
        this(8192);
    }

    public ReaderWriterCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public ReaderWriterCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public ReaderWriterCopier(int bufferSize, long count, StreamProgress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(Reader source, Writer target) {
        long size;
        Preconditions.notNull(source, "InputStream is null !", new Object[0]);
        Preconditions.notNull(target, "OutputStream is null !", new Object[0]);
        StreamProgress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, new char[this.bufferSize(this.count)], progress);
            target.flush();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(Reader source, Writer target, char[] buffer, StreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer, 0, this.bufferSize(numToRead))) >= 0) {
            target.write(buffer, 0, read);
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(total);
        }
        return total;
    }
}

