/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.sql;

import com.whaleal.icefrog.core.collection.CollUtil;
import com.whaleal.icefrog.core.collection.CollectionUtil;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.Entity;
import com.whaleal.icefrog.db.sql.Condition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class Wrapper {
    private Character preWrapQuote;
    private Character sufWrapQuote;

    public Wrapper() {
    }

    public Wrapper(Character wrapQuote) {
        this.preWrapQuote = wrapQuote;
        this.sufWrapQuote = wrapQuote;
    }

    public Wrapper(Character preWrapQuote, Character sufWrapQuote) {
        this.preWrapQuote = preWrapQuote;
        this.sufWrapQuote = sufWrapQuote;
    }

    public char getPreWrapQuote() {
        return this.preWrapQuote.charValue();
    }

    public void setPreWrapQuote(Character preWrapQuote) {
        this.preWrapQuote = preWrapQuote;
    }

    public char getSufWrapQuote() {
        return this.sufWrapQuote.charValue();
    }

    public void setSufWrapQuote(Character sufWrapQuote) {
        this.sufWrapQuote = sufWrapQuote;
    }

    public String wrap(String field) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StrUtil.isBlank(field)) {
            return field;
        }
        if (StrUtil.isSurround((CharSequence)field, this.preWrapQuote.charValue(), this.sufWrapQuote.charValue())) {
            return field;
        }
        if (StrUtil.containsAnyIgnoreCase(field, "*", "(", " ", " as ")) {
            return field;
        }
        if (field.contains(".")) {
            Collection<String> target = CollUtil.edit(StrUtil.split(field, '.', 2), t -> StrUtil.format("{}{}{}", this.preWrapQuote, t, this.sufWrapQuote));
            return CollectionUtil.join(target, (CharSequence)".");
        }
        return StrUtil.format("{}{}{}", this.preWrapQuote, field, this.sufWrapQuote);
    }

    public String[] wrap(String ... fields) {
        if (ArrayUtil.isEmpty(fields)) {
            return fields;
        }
        String[] wrappedFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            wrappedFields[i] = this.wrap(fields[i]);
        }
        return wrappedFields;
    }

    public Collection<String> wrap(Collection<String> fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return fields;
        }
        return Arrays.asList(this.wrap(fields.toArray(new String[0])));
    }

    public Entity wrap(Entity entity) {
        if (null == entity) {
            return null;
        }
        Entity wrapedEntity = new Entity();
        wrapedEntity.setTableName(this.wrap(entity.getTableName()));
        for (Map.Entry entry : entity.entrySet()) {
            wrapedEntity.set(this.wrap((String)entry.getKey()), entry.getValue());
        }
        return wrapedEntity;
    }

    public Condition[] wrap(Condition ... conditions) {
        Condition[] clonedConditions = new Condition[conditions.length];
        if (ArrayUtil.isNotEmpty(conditions)) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition clonedCondition = (Condition)conditions[i].clone();
                clonedCondition.setField(this.wrap(clonedCondition.getField()));
                clonedConditions[i] = clonedCondition;
            }
        }
        return clonedConditions;
    }
}

