/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.json;

import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.NumberUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.json.JSONArray;
import com.whaleal.icefrog.json.JSONConfig;
import com.whaleal.icefrog.json.JSONException;
import com.whaleal.icefrog.json.JSONGetter;
import com.whaleal.icefrog.json.JSONNull;
import com.whaleal.icefrog.json.JSONObject;
import com.whaleal.icefrog.json.JSONString;
import com.whaleal.icefrog.json.JSONTokener;
import com.whaleal.icefrog.json.JSONUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;

public final class InternalJSONUtil {
    private InternalJSONUtil() {
    }

    static void testValidity(Object obj) throws JSONException {
        if (!ObjectUtil.isValidIfNumber(obj)) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null || value instanceof JSONNull) {
            return JSONNull.NULL.toString();
        }
        if (value instanceof JSONString) {
            try {
                return ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
        }
        if (value instanceof Number) {
            return NumberUtil.toStr((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new JSONObject(map).toString();
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            return new JSONArray((Object)coll).toString();
        }
        if (ArrayUtil.isArray(value)) {
            return new JSONArray(value).toString();
        }
        return JSONUtil.quote(value.toString());
    }

    public static Object stringToValue(String string) {
        if (StrUtil.isEmpty(string) || "null".equalsIgnoreCase(string)) {
            return JSONNull.NULL;
        }
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-') {
            try {
                if (StrUtil.containsAnyIgnoreCase(string, ".", "e")) {
                    return new BigDecimal(string);
                }
                long myLong = Long.parseLong(string);
                if (string.equals(Long.toString(myLong))) {
                    if (myLong == (long)((int)myLong)) {
                        return (int)myLong;
                    }
                    return myLong;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    static JSONObject propertyPut(JSONObject jsonObject, Object key, Object value) {
        String[] path = StrUtil.splitToArray((CharSequence)Convert.toStr(key), '.');
        int last = path.length - 1;
        JSONObject target = jsonObject;
        for (int i = 0; i < last; ++i) {
            String segment = path[i];
            JSONObject nextTarget = target.getJSONObject(segment);
            if (nextTarget == null) {
                nextTarget = new JSONObject(target.getConfig());
                target.set(segment, nextTarget);
            }
            target = nextTarget;
        }
        target.set(path[last], value);
        return jsonObject;
    }

    static boolean defaultIgnoreNullValue(Object obj) {
        return false == obj instanceof CharSequence && false == obj instanceof JSONTokener && false == obj instanceof Map;
    }

    static boolean isOrder(Object value) {
        JSONConfig config;
        if (value instanceof LinkedHashMap || value instanceof SortedMap) {
            return true;
        }
        if (value instanceof JSONGetter && null != (config = ((JSONGetter)value).getConfig())) {
            return config.isOrder();
        }
        return false;
    }
}

