/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.math;

import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.math.Arrangement;
import com.whaleal.icefrog.core.math.Combination;
import com.whaleal.icefrog.core.math.Money;
import com.whaleal.icefrog.core.util.NumberUtil;
import java.math.RoundingMode;
import java.util.List;

public class MathUtil {
    static final int MAX_POWER_OF_SQRT2_UNSIGNED = -1257966797;

    public static long arrangementCount(int n, int m) {
        return Arrangement.count(n, m);
    }

    public static long arrangementCount(int n) {
        return Arrangement.count(n);
    }

    public static List<String[]> arrangementSelect(String[] datas, int m) {
        return new Arrangement(datas).select(m);
    }

    public static List<String[]> arrangementSelect(String[] datas) {
        return new Arrangement(datas).select();
    }

    public static long combinationCount(int n, int m) {
        return Combination.count(n, m);
    }

    public static List<String[]> combinationSelect(String[] datas, int m) {
        return new Combination(datas).select(m);
    }

    public static long yuanToCent(double yuan) {
        return new Money(yuan).getCent();
    }

    public static double centToYuan(long cent) {
        long yuan = cent / 100L;
        int centPart = (int)(cent % 100L);
        return new Money(yuan, centPart).getAmount().doubleValue();
    }

    public static int checkedMultiply(int a, int b) {
        long result = (long)a * (long)b;
        MathUtil.checkNoOverflow(result == (long)((int)result), "checkedMultiply", a, b);
        return (int)result;
    }

    public static long checkedMultiply(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        MathUtil.checkNoOverflow(leadingZeros >= 64, "checkedMultiply", a, b);
        MathUtil.checkNoOverflow(a >= 0L | b != Long.MIN_VALUE, "checkedMultiply", a, b);
        long result = a * b;
        MathUtil.checkNoOverflow(a == 0L || result / a == b, "checkedMultiply", a, b);
        return result;
    }

    public static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a + ", " + b + ")");
        }
    }

    public static void checkNoOverflow(boolean condition, String methodName, long a, long b) {
        if (!condition) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a + ", " + b + ")");
        }
    }

    public static int log2(int x, RoundingMode mode) {
        Preconditions.checkPositive("x", x);
        switch (mode) {
            case UNNECESSARY: {
                MathUtil.checkRoundingUnnecessary(NumberUtil.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(x - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Integer.numberOfLeadingZeros(x);
                int cmp = -1257966797 >>> leadingZeros;
                int logFloor = 31 - leadingZeros;
                return logFloor + MathUtil.lessThanBranchFree(cmp, x);
            }
        }
        throw new AssertionError();
    }

    public static int lessThanBranchFree(int x, int y) {
        return ~(~(x - y)) >>> 31;
    }

    public static int lessThanBranchFree(long x, long y) {
        return (int)((x - y ^ 0xFFFFFFFFFFFFFFFFL ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
    }

    public static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }
}

