/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.poi.excel;

import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.poi.excel.ExcelBase;
import com.whaleal.icefrog.poi.excel.ExcelExtractorUtil;
import com.whaleal.icefrog.poi.excel.ExcelWriter;
import com.whaleal.icefrog.poi.excel.RowUtil;
import com.whaleal.icefrog.poi.excel.WorkbookUtil;
import com.whaleal.icefrog.poi.excel.cell.CellEditor;
import com.whaleal.icefrog.poi.excel.cell.CellHandler;
import com.whaleal.icefrog.poi.excel.cell.CellUtil;
import com.whaleal.icefrog.poi.excel.reader.BeanSheetReader;
import com.whaleal.icefrog.poi.excel.reader.ListSheetReader;
import com.whaleal.icefrog.poi.excel.reader.MapSheetReader;
import com.whaleal.icefrog.poi.excel.reader.SheetReader;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReader
extends ExcelBase<ExcelReader> {
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;
    private Map<String, String> headerAlias = new HashMap<String, String>();

    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileUtil.file(excelFilePath), sheetIndex);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorkbookUtil.createBook(bookFile), sheetIndex);
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(WorkbookUtil.createBook(bookFile), sheetName);
    }

    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(WorkbookUtil.createBook(bookStream), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName) {
        this(WorkbookUtil.createBook(bookStream), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(book.getSheetAt(sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(book.getSheet(sheetName));
    }

    public ExcelReader(Sheet sheet) {
        super(sheet);
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
        return this;
    }

    public ExcelReader setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    public Map<String, String> getHeaderAlias() {
        return this.headerAlias;
    }

    public ExcelReader setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelReader addHeaderAlias(String header, String alias) {
        this.headerAlias.put(header, alias);
        return this;
    }

    public ExcelReader removeHeaderAlias(String header) {
        this.headerAlias.remove(header);
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        return this.read(startRowIndex, endRowIndex, true);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        ListSheetReader reader = new ListSheetReader(startRowIndex, endRowIndex, aliasFirstLine);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return this.read(reader);
    }

    public void read(CellHandler cellHandler) {
        this.read(0, Integer.MAX_VALUE, cellHandler);
    }

    public void read(int startRowIndex, int endRowIndex, CellHandler cellHandler) {
        this.checkNotClosed();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = this.sheet.getRow(y);
            short columnSize = row.getLastCellNum();
            for (short x = 0; x < columnSize; x = (short)(x + 1)) {
                Cell cell = row.getCell((int)x);
                cellHandler.handle(cell, CellUtil.getCellValue(cell));
            }
        }
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        MapSheetReader reader = new MapSheetReader(headerRowIndex, startRowIndex, endRowIndex);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return this.read(reader);
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        BeanSheetReader<T> reader = new BeanSheetReader<T>(headerRowIndex, startRowIndex, endRowIndex, beanType);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return (List)this.read(reader);
    }

    public <T> T read(SheetReader<T> sheetReader) {
        this.checkNotClosed();
        return Preconditions.notNull(sheetReader).read(this.sheet);
    }

    public String readAsText(boolean withSheetName) {
        return ExcelExtractorUtil.readAsText(this.workbook, withSheetName);
    }

    public ExcelExtractor getExtractor() {
        return ExcelExtractorUtil.getExtractor(this.workbook);
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return CellUtil.getCellValue(this.getCell(x, y), this.cellEditor);
    }

    public ExcelWriter getWriter() {
        return new ExcelWriter(this.sheet);
    }

    private List<Object> readRow(Row row) {
        return RowUtil.readRow(row, this.cellEditor);
    }

    private void checkNotClosed() {
        Preconditions.isFalse(this.isClosed, "ExcelReader has been closed!", new Object[0]);
    }
}

