/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.script;

import com.whaleal.icefrog.core.lang.SimpleCache;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.script.JavaScriptEngine;
import com.whaleal.icefrog.script.ScriptRuntimeException;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptUtil {
    private static final ScriptEngineManager MANAGER = new ScriptEngineManager();
    private static final SimpleCache<String, ScriptEngine> CACHE = new SimpleCache();

    public static ScriptEngine getScript(String nameOrExtOrMime) {
        return CACHE.get(nameOrExtOrMime, () -> ScriptUtil.createScript(nameOrExtOrMime));
    }

    public static ScriptEngine createScript(String nameOrExtOrMime) {
        ScriptEngine engine = MANAGER.getEngineByName(nameOrExtOrMime);
        if (null == engine) {
            engine = MANAGER.getEngineByExtension(nameOrExtOrMime);
        }
        if (null == engine) {
            engine = MANAGER.getEngineByMimeType(nameOrExtOrMime);
        }
        if (null == engine) {
            throw new NullPointerException(StrUtil.format("Script for [{}] not support !", nameOrExtOrMime));
        }
        return engine;
    }

    public static JavaScriptEngine getJavaScriptEngine() {
        return new JavaScriptEngine();
    }

    public static ScriptEngine getJsEngine() {
        return ScriptUtil.getScript("js");
    }

    public static ScriptEngine createJsEngine() {
        return ScriptUtil.createScript("js");
    }

    public static ScriptEngine getPythonEngine() {
        System.setProperty("python.import.site", "false");
        return ScriptUtil.getScript("python");
    }

    public static ScriptEngine createPythonEngine() {
        System.setProperty("python.import.site", "false");
        return ScriptUtil.createScript("python");
    }

    public static ScriptEngine getLuaEngine() {
        return ScriptUtil.getScript("lua");
    }

    public static ScriptEngine createLuaEngine() {
        return ScriptUtil.createScript("lua");
    }

    public static ScriptEngine getGroovyEngine() {
        return ScriptUtil.getScript("groovy");
    }

    public static ScriptEngine createGroovyEngine() {
        return ScriptUtil.createScript("groovy");
    }

    public static Invocable evalInvocable(String script) throws ScriptRuntimeException {
        Object eval;
        ScriptEngine jsEngine = ScriptUtil.getJsEngine();
        try {
            eval = jsEngine.eval(script);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
        if (eval instanceof Invocable) {
            return (Invocable)eval;
        }
        if (jsEngine instanceof Invocable) {
            return (Invocable)((Object)jsEngine);
        }
        throw new ScriptRuntimeException("Script is not invocable !");
    }

    public static Object eval(String script) throws ScriptRuntimeException {
        try {
            return ScriptUtil.getJsEngine().eval(script);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static Object eval(String script, ScriptContext context) throws ScriptRuntimeException {
        try {
            return ScriptUtil.getJsEngine().eval(script, context);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static Object eval(String script, Bindings bindings) throws ScriptRuntimeException {
        try {
            return ScriptUtil.getJsEngine().eval(script, bindings);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static Object invoke(String script, String func, Object ... args) {
        Invocable eval = ScriptUtil.evalInvocable(script);
        try {
            return eval.invokeFunction(func, args);
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static CompiledScript compile(String script) throws ScriptRuntimeException {
        try {
            return ScriptUtil.compile(ScriptUtil.getJsEngine(), script);
        }
        catch (ScriptException e) {
            throw new ScriptRuntimeException(e);
        }
    }

    public static CompiledScript compile(ScriptEngine engine, String script) throws ScriptException {
        if (engine instanceof Compilable) {
            Compilable compEngine = (Compilable)((Object)engine);
            return compEngine.compile(script);
        }
        return null;
    }
}

