/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang;

import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.lang.SimpleCache;
import com.whaleal.icefrog.core.lang.func.Func0;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.ClassUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.util.HashMap;

public final class Singleton {
    private static final SimpleCache<String, Object> POOL = new SimpleCache(new HashMap());

    private Singleton() {
    }

    public static <T> T get(Class<T> clazz, Object ... params) {
        Preconditions.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Singleton.buildKey(clazz.getName(), params);
        return (T)Singleton.get(key, () -> ReflectUtil.newInstance(clazz, params));
    }

    public static <T> T get(String key, Func0<T> supplier) {
        return (T)POOL.get(key, supplier::apply);
    }

    public static <T> T get(String className, Object ... params) {
        Preconditions.notBlank(className, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassUtil.loadClass(className);
        return Singleton.get(clazz, params);
    }

    public static void put(Object obj) {
        Preconditions.notNull(obj, "Bean object must be not null !", new Object[0]);
        Singleton.put(obj.getClass().getName(), obj);
    }

    public static void put(String key, Object obj) {
        POOL.put(key, obj);
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            Singleton.remove(clazz.getName());
        }
    }

    public static void remove(String key) {
        POOL.remove(key);
    }

    public static void destroy() {
        POOL.clear();
    }

    private static String buildKey(String className, Object ... params) {
        if (ArrayUtil.isEmpty(params)) {
            return className;
        }
        return StrUtil.format("{}#{}", className, ArrayUtil.join(params, (CharSequence)"_"));
    }
}

