/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang.tree;

import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.lang.tree.Tree;
import com.whaleal.icefrog.core.lang.tree.TreeBuilder;
import com.whaleal.icefrog.core.lang.tree.TreeNode;
import com.whaleal.icefrog.core.lang.tree.TreeNodeConfig;
import com.whaleal.icefrog.core.lang.tree.parser.DefaultNodeParser;
import com.whaleal.icefrog.core.lang.tree.parser.NodeParser;
import com.whaleal.icefrog.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TreeUtil {
    public static Tree<Integer> buildSingle(List<TreeNode<Integer>> list) {
        return TreeUtil.buildSingle(list, Integer.valueOf(0));
    }

    public static List<Tree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtil.build(list, Integer.valueOf(0));
    }

    public static <E> Tree<E> buildSingle(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <E> List<Tree<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> Tree<E> buildSingle(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeUtil.buildSingle(list, rootId, treeNodeConfig, nodeParser).getChildren();
    }

    public static <T, E> Tree<E> buildSingle(List<T> list, E rootId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        return TreeBuilder.of(rootId, treeNodeConfig).append(list, nodeParser).build();
    }

    public static <E> List<Tree<E>> build(Map<E, Tree<E>> map, E rootId) {
        return TreeUtil.buildSingle(map, rootId).getChildren();
    }

    public static <E> Tree<E> buildSingle(Map<E, Tree<E>> map, E rootId) {
        Tree<E> tree = IterUtil.getFirstNoneNull(map.values());
        if (null != tree) {
            TreeNodeConfig config = tree.getConfig();
            return TreeBuilder.of(rootId, config).append(map).build();
        }
        return TreeUtil.createEmptyNode(rootId);
    }

    public static <T> Tree<T> getNode(Tree<T> node, T id) {
        if (ObjectUtil.equal(id, node.getId())) {
            return node;
        }
        List<Tree<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (Tree<T> child : children) {
            Tree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(Tree<T> node, boolean includeCurrentNode) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getName());
        }
        for (Tree<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            result.add(parent.getName());
        }
        return result;
    }

    public static <E> Tree<E> createEmptyNode(E id) {
        return new Tree().setId(id);
    }
}

