/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.text;

import com.whaleal.icefrog.core.util.NumberUtil;
import com.whaleal.icefrog.core.util.StrUtil;

public class TextSimilarity {
    public static double similar(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = TextSimilarity.removeSign(strB);
            newStrB = TextSimilarity.removeSign(strA);
        } else {
            newStrA = TextSimilarity.removeSign(strA);
            newStrB = TextSimilarity.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int icefrogLength = TextSimilarity.longesticefrogSubstringLength(newStrA, newStrB);
        return NumberUtil.div((float)icefrogLength, (float)temp);
    }

    public static String similar(String strA, String strB, int scale) {
        return NumberUtil.formatPercent(TextSimilarity.similar(strA, strB), scale);
    }

    public static String longesticefrogSubstring(String strA, String strB) {
        int[][] matrix = TextSimilarity.generateMatrix(strA, strB);
        int m = strA.length();
        int n = strB.length();
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[m][n] == matrix[m][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = strA.charAt(m - 1);
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }

    private static String removeSign(String str) {
        int length = str.length();
        StringBuilder sb = StrUtil.builder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (!TextSimilarity.isValidChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isValidChar(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static int longesticefrogSubstringLength(String strA, String strB) {
        int m = strA.length();
        int n = strB.length();
        return TextSimilarity.generateMatrix(strA, strB)[m][n];
    }

    private static int[][] generateMatrix(String strA, String strB) {
        int m = strA.length();
        int n = strB.length();
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = strA.charAt(i - 1) == strB.charAt(j - 1) ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        return matrix;
    }
}

