/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.emoji.loader;

import com.whaleal.icefrog.extra.emoji.model.Emoji;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class EmojiTrie {
    private Node root = new Node();

    public EmojiTrie(Collection<Emoji> emojis) {
        for (Emoji emoji : emojis) {
            Node tree = this.root;
            for (char c : emoji.getUnicode().toCharArray()) {
                if (!tree.hasChild(c)) {
                    tree.addChild(c);
                }
                tree = tree.getChild(c);
            }
            tree.setEmoji(emoji);
        }
    }

    public Matches isEmoji(char[] sequence) {
        if (sequence == null) {
            return Matches.POSSIBLY;
        }
        Node tree = this.root;
        for (char c : sequence) {
            if (!tree.hasChild(c)) {
                return Matches.IMPOSSIBLE;
            }
            tree = tree.getChild(c);
        }
        return tree.isEndOfEmoji() ? Matches.EXACTLY : Matches.POSSIBLY;
    }

    public Emoji getEmoji(String unicode) {
        Node tree = this.root;
        for (char c : unicode.toCharArray()) {
            if (!tree.hasChild(c)) {
                return null;
            }
            tree = tree.getChild(c);
        }
        return tree.getEmoji();
    }

    private class Node {
        private Map<Character, Node> children = new HashMap<Character, Node>();
        private Emoji emoji;

        private Node() {
        }

        private void setEmoji(Emoji emoji) {
            this.emoji = emoji;
        }

        private Emoji getEmoji() {
            return this.emoji;
        }

        private boolean hasChild(char child) {
            return this.children.containsKey(Character.valueOf(child));
        }

        private void addChild(char child) {
            this.children.put(Character.valueOf(child), new Node());
        }

        private Node getChild(char child) {
            return this.children.get(Character.valueOf(child));
        }

        private boolean isEndOfEmoji() {
            return this.emoji != null;
        }
    }

    public static enum Matches {
        EXACTLY,
        POSSIBLY,
        IMPOSSIBLE;


        public boolean exactMatch() {
            return this == EXACTLY;
        }

        public boolean impossibleMatch() {
            return this == IMPOSSIBLE;
        }
    }
}

