/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.pinyin;

import com.whaleal.icefrog.extra.pinyin.PinyinEngine;
import com.whaleal.icefrog.extra.pinyin.engine.PinyinFactory;

public class PinyinUtil {
    private static final String CHINESE_REGEX = "[\\u4e00-\\u9fa5]";

    public static PinyinEngine getEngine() {
        return PinyinFactory.get();
    }

    public static String getPinyin(char c) {
        return PinyinUtil.getEngine().getPinyin(c);
    }

    public static String getPinyin(String str) {
        return PinyinUtil.getPinyin(str, " ");
    }

    public static String getPinyin(String str, String separator) {
        return PinyinUtil.getEngine().getPinyin(str, separator);
    }

    public static char getFirstLetter(char c) {
        return PinyinUtil.getEngine().getFirstLetter(c);
    }

    public static String getFirstLetter(String str, String separator) {
        return PinyinUtil.getEngine().getFirstLetter(str, separator);
    }

    public static boolean isChinese(char c) {
        return '\u3007' == c || String.valueOf(c).matches(CHINESE_REGEX);
    }
}

