/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.tokenizer.engine;

import com.whaleal.icefrog.core.lang.Singleton;
import com.whaleal.icefrog.core.util.ServiceLoaderUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.extra.tokenizer.TokenizerEngine;
import com.whaleal.icefrog.extra.tokenizer.TokenizerException;
import com.whaleal.icefrog.log.StaticLog;

public class TokenizerFactory {
    public static TokenizerEngine get() {
        return Singleton.get(TokenizerEngine.class.getName(), TokenizerFactory::create);
    }

    public static TokenizerEngine create() {
        TokenizerEngine engine = TokenizerFactory.doCreate();
        StaticLog.debug("Use [{}] Tokenizer Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static TokenizerEngine doCreate() {
        TokenizerEngine engine = ServiceLoaderUtil.loadFirstAvailable(TokenizerEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new TokenizerException("No tokenizer found ! Please add some tokenizer jar to your project !");
    }
}

