/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.json;

import com.whaleal.icefrog.core.convert.Convert;
import com.whaleal.icefrog.core.convert.ConvertException;
import com.whaleal.icefrog.core.convert.Converter;
import com.whaleal.icefrog.core.convert.ConverterRegistry;
import com.whaleal.icefrog.core.convert.impl.ArrayConverter;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.core.util.TypeUtil;
import com.whaleal.icefrog.json.JSON;
import com.whaleal.icefrog.json.JSONArray;
import com.whaleal.icefrog.json.JSONBeanParser;
import com.whaleal.icefrog.json.JSONObject;
import com.whaleal.icefrog.json.JSONUtil;
import com.whaleal.icefrog.json.serialize.GlobalSerializeMapping;
import com.whaleal.icefrog.json.serialize.JSONDeserializer;
import java.lang.reflect.Type;
import java.util.List;

public class JSONConverter
implements Converter<JSON> {
    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass) {
        return new ArrayConverter(arrayClass).convert(jsonArray, null);
    }

    protected static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return Convert.toList(elementType, jsonArray);
    }

    protected static <T> T jsonConvert(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        Class clazz;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (targetType instanceof Class && JSONBeanParser.class.isAssignableFrom(clazz = (Class)targetType)) {
            JSONBeanParser target = (JSONBeanParser)ReflectUtil.newInstanceIfPossible(clazz);
            if (null == target) {
                throw new ConvertException("Can not instance [{}]", targetType);
            }
            target.parse(value);
            return (T)target;
        }
        return JSONConverter.jsonToBean(targetType, value, ignoreError);
    }

    protected static <T> T jsonToBean(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        JSONDeserializer<?> deserializer;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (value instanceof JSON && null != (deserializer = GlobalSerializeMapping.getDeserializer(targetType))) {
            return (T)deserializer.deserialize((JSON)value);
        }
        T targetValue = Convert.convertWithCheck(targetType, value, null, ignoreError);
        if (null == targetValue && !ignoreError) {
            if (StrUtil.isBlankIfStr(value)) {
                return null;
            }
            throw new ConvertException("Can not convert {} to type {}", value, ObjectUtil.defaultIfNull(TypeUtil.getClass(targetType), targetType));
        }
        return targetValue;
    }

    @Override
    public JSON convert(Object value, JSON defaultValue) throws IllegalArgumentException {
        return JSONUtil.parse(value);
    }

    static {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        registry.putCustom((Type)((Object)JSON.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONObject.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONArray.class), (Class<? extends Converter<?>>)JSONConverter.class);
    }
}

