/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.jwt;

import com.whaleal.icefrog.core.codec.Base64;
import com.whaleal.icefrog.core.lang.Preconditions;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.json.JSONConfig;
import com.whaleal.icefrog.json.JSONObject;
import com.whaleal.icefrog.json.JSONUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;

public class Claims
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JSONConfig CONFIG = JSONConfig.create().setDateFormat("#sss").setOrder(true);
    private JSONObject claimJSON;

    protected void setClaim(String name, Object value) {
        this.init();
        Preconditions.notNull(name, "Name must be not null!");
        if (value == null) {
            this.claimJSON.remove(name);
            return;
        }
        this.claimJSON.set(name, value);
    }

    protected void putAll(Map<String, ?> headerClaims) {
        if (MapUtil.isNotEmpty(headerClaims)) {
            for (Map.Entry<String, ?> entry : headerClaims.entrySet()) {
                this.setClaim(entry.getKey(), entry.getValue());
            }
        }
    }

    public Object getClaim(String name) {
        this.init();
        return this.claimJSON.getObj(name);
    }

    public JSONObject getClaimsJson() {
        this.init();
        return this.claimJSON;
    }

    public void parse(String tokenPart, Charset charset) {
        this.claimJSON = JSONUtil.parseObj((Object)Base64.decodeStr((CharSequence)tokenPart, charset), this.CONFIG);
    }

    public String toString() {
        this.init();
        return this.claimJSON.toString();
    }

    private void init() {
        if (null == this.claimJSON) {
            this.claimJSON = new JSONObject(this.CONFIG);
        }
    }
}

