package com.whaleal.icefrog.db.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.*;
import java.util.Calendar;

/**
 * {@link PreparedStatement} 包装类，用于添加拦截方法功能<br>
 * 拦截方法包括：
 *
 * <pre>
 * 1. 提供参数注入
 * 2. 提供SQL打印日志拦截
 * </pre>
 *
 * @author Looly
 * @author wh
 * @since 1.0.0
 */
public class StatementWrapper implements PreparedStatement {

    private PreparedStatement rawStatement;

    /**
     * 构造
     *
     * @param rawStatement {@link PreparedStatement}
     */
    public StatementWrapper( PreparedStatement rawStatement ) {
        this.rawStatement = rawStatement;
    }

    @Override
    public ResultSet executeQuery( String sql ) throws SQLException {
        return rawStatement.executeQuery(sql);
    }

    @Override
    public int executeUpdate( String sql ) throws SQLException {
        return rawStatement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        rawStatement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return rawStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize( int max ) throws SQLException {
        rawStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return rawStatement.getMaxRows();
    }

    @Override
    public void setMaxRows( int max ) throws SQLException {
        rawStatement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing( boolean enable ) throws SQLException {
        rawStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return rawStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout( int seconds ) throws SQLException {
        rawStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        rawStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return rawStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        rawStatement.clearWarnings();
    }

    @Override
    public void setCursorName( String name ) throws SQLException {
        rawStatement.setCursorName(name);
    }

    @Override
    public boolean execute( String sql ) throws SQLException {
        return rawStatement.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return rawStatement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return rawStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return rawStatement.getMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return rawStatement.getFetchDirection();
    }

    @Override
    public void setFetchDirection( int direction ) throws SQLException {
        rawStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return rawStatement.getFetchSize();
    }

    @Override
    public void setFetchSize( int rows ) throws SQLException {
        rawStatement.setFetchSize(rows);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return rawStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return rawStatement.getResultSetType();
    }

    @Override
    public void addBatch( String sql ) throws SQLException {
        rawStatement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        rawStatement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return rawStatement.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return rawStatement.getConnection();
    }

    @Override
    public boolean getMoreResults( int current ) throws SQLException {
        return rawStatement.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return rawStatement.getGeneratedKeys();
    }

    @Override
    public int executeUpdate( String sql, int autoGeneratedKeys ) throws SQLException {
        return rawStatement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate( String sql, int[] columnIndexes ) throws SQLException {
        return rawStatement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate( String sql, String[] columnNames ) throws SQLException {
        return rawStatement.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute( String sql, int autoGeneratedKeys ) throws SQLException {
        return rawStatement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute( String sql, int[] columnIndexes ) throws SQLException {
        return rawStatement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute( String sql, String[] columnNames ) throws SQLException {
        return rawStatement.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return rawStatement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return rawStatement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return rawStatement.isPoolable();
    }

    @Override
    public void setPoolable( boolean poolable ) throws SQLException {
        rawStatement.setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        rawStatement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return rawStatement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap( Class<T> iface ) throws SQLException {
        return rawStatement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor( Class<?> iface ) throws SQLException {
        return rawStatement.isWrapperFor(iface);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return rawStatement.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return rawStatement.executeUpdate();
    }

    @Override
    public void setNull( int parameterIndex, int sqlType ) throws SQLException {
        rawStatement.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setBoolean( int parameterIndex, boolean x ) throws SQLException {
        rawStatement.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte( int parameterIndex, byte x ) throws SQLException {
        rawStatement.setByte(parameterIndex, x);
    }

    @Override
    public void setShort( int parameterIndex, short x ) throws SQLException {
        rawStatement.setShort(parameterIndex, x);
    }

    @Override
    public void setInt( int parameterIndex, int x ) throws SQLException {
        rawStatement.setInt(parameterIndex, x);
    }

    @Override
    public void setLong( int parameterIndex, long x ) throws SQLException {
        rawStatement.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat( int parameterIndex, float x ) throws SQLException {
        rawStatement.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble( int parameterIndex, double x ) throws SQLException {
        rawStatement.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal( int parameterIndex, BigDecimal x ) throws SQLException {
        rawStatement.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString( int parameterIndex, String x ) throws SQLException {
        rawStatement.setString(parameterIndex, x);
    }

    @Override
    public void setBytes( int parameterIndex, byte[] x ) throws SQLException {
        rawStatement.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate( int parameterIndex, Date x ) throws SQLException {
        rawStatement.setDate(parameterIndex, x);
    }

    @Override
    public void setTime( int parameterIndex, Time x ) throws SQLException {
        rawStatement.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp( int parameterIndex, Timestamp x ) throws SQLException {
        rawStatement.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream( int parameterIndex, InputStream x, int length ) throws SQLException {
        rawStatement.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    @Deprecated
    public void setUnicodeStream( int parameterIndex, InputStream x, int length ) throws SQLException {
        rawStatement.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream( int parameterIndex, InputStream x, int length ) throws SQLException {
        rawStatement.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void clearParameters() throws SQLException {
        rawStatement.clearParameters();
    }

    @Override
    public void setObject( int parameterIndex, Object x, int targetSqlType ) throws SQLException {
        rawStatement.setObject(parameterIndex, x, targetSqlType, targetSqlType);
    }

    @Override
    public void setObject( int parameterIndex, Object x ) throws SQLException {
        rawStatement.setObject(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return rawStatement.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        rawStatement.addBatch();
    }

    @Override
    public void setCharacterStream( int parameterIndex, Reader reader, int length ) throws SQLException {
        rawStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setRef( int parameterIndex, Ref x ) throws SQLException {
        rawStatement.setRef(parameterIndex, x);
    }

    @Override
    public void setBlob( int parameterIndex, Blob x ) throws SQLException {
        rawStatement.setBlob(parameterIndex, x);
    }

    @Override
    public void setClob( int parameterIndex, Clob x ) throws SQLException {
        rawStatement.setClob(parameterIndex, x);
    }

    @Override
    public void setArray( int parameterIndex, Array x ) throws SQLException {
        rawStatement.setArray(parameterIndex, x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return rawStatement.getMetaData();
    }

    @Override
    public void setDate( int parameterIndex, Date x, Calendar cal ) throws SQLException {
        rawStatement.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime( int parameterIndex, Time x, Calendar cal ) throws SQLException {
        rawStatement.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp( int parameterIndex, Timestamp x, Calendar cal ) throws SQLException {
        rawStatement.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setNull( int parameterIndex, int sqlType, String typeName ) throws SQLException {
        rawStatement.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setURL( int parameterIndex, URL x ) throws SQLException {
        rawStatement.setURL(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return rawStatement.getParameterMetaData();
    }

    @Override
    public void setRowId( int parameterIndex, RowId x ) throws SQLException {
        rawStatement.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString( int parameterIndex, String value ) throws SQLException {
        rawStatement.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream( int parameterIndex, Reader value, long length ) throws SQLException {
        rawStatement.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob( int parameterIndex, NClob value ) throws SQLException {
        rawStatement.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob( int parameterIndex, Reader reader, long length ) throws SQLException {
        rawStatement.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob( int parameterIndex, InputStream inputStream, long length ) throws SQLException {
        rawStatement.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob( int parameterIndex, Reader reader, long length ) throws SQLException {
        rawStatement.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML( int parameterIndex, SQLXML xmlObject ) throws SQLException {
        rawStatement.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setObject( int parameterIndex, Object x, int targetSqlType, int scaleOrLength ) throws SQLException {
        rawStatement.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setAsciiStream( int parameterIndex, InputStream x, long length ) throws SQLException {
        rawStatement.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream( int parameterIndex, InputStream x, long length ) throws SQLException {
        rawStatement.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream( int parameterIndex, Reader reader, long length ) throws SQLException {
        rawStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream( int parameterIndex, InputStream x ) throws SQLException {
        rawStatement.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream( int parameterIndex, InputStream x ) throws SQLException {
        rawStatement.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream( int parameterIndex, Reader reader ) throws SQLException {
        rawStatement.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream( int parameterIndex, Reader value ) throws SQLException {
        rawStatement.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob( int parameterIndex, Reader reader ) throws SQLException {
        rawStatement.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob( int parameterIndex, InputStream inputStream ) throws SQLException {
        rawStatement.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob( int parameterIndex, Reader reader ) throws SQLException {
        rawStatement.setNClob(parameterIndex, reader);
    }

}
