/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.codec;

import com.whaleal.icefrog.core.codec.DecoderException;
import com.whaleal.icefrog.core.codec.EncoderException;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import java.awt.Color;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class Hex {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static byte[] decodeHex(char[] data) throws DecoderException {
        byte[] out = new byte[data.length >> 1];
        Hex.decodeHex(data, out, 0);
        return out;
    }

    public static int decodeHex(char[] data, byte[] out, int outOffset) throws DecoderException {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new DecoderException("Odd number of characters.");
        }
        int outLen = len >> 1;
        if (out.length - outOffset < outLen) {
            throw new DecoderException("Output array is not large enough to accommodate decoded data.");
        }
        int i = outOffset;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(data[j], j) << 4;
            f |= Hex.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return outLen;
    }

    public static byte[] decodeHex(String data) throws DecoderException {
        return Hex.decodeHex((CharSequence)data);
    }

    public static byte[] decodeHex(CharSequence hexData) throws DecoderException {
        if (StrUtil.isEmpty(hexData)) {
            return null;
        }
        int len = (hexData = StrUtil.cleanBlank(hexData)).length();
        if ((len & 1) != 0) {
            hexData = "0" + hexData;
            len = hexData.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Hex.toDigit(hexData.charAt(j), j) << 4;
            f |= Hex.toDigit(hexData.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static char[] encodeHex(byte[] data) {
        return Hex.encodeHex(data, true);
    }

    public static char[] encodeHex(ByteBuffer data, boolean toLowerCase) {
        return Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Hex.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static char[] encodeHex(byte[] data, char[] toDigits) {
        int dataLength = data.length;
        char[] out = new char[dataLength << 1];
        Hex.encodeHex(data, 0, dataLength, toDigits, out, 0);
        return out;
    }

    public static char[] encodeHex(byte[] data, int dataOffset, int dataLen, boolean toLowerCase) {
        char[] out = new char[dataLen << 1];
        Hex.encodeHex(data, dataOffset, dataLen, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER, out, 0);
        return out;
    }

    public static void encodeHex(byte[] data, int dataOffset, int dataLen, boolean toLowerCase, char[] out, int outOffset) {
        Hex.encodeHex(data, dataOffset, dataLen, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER, out, outOffset);
    }

    private static void encodeHex(byte[] data, int dataOffset, int dataLen, char[] toDigits, char[] out, int outOffset) {
        int j = outOffset;
        for (int i = dataOffset; i < dataOffset + dataLen; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
    }

    public static char[] encodeHex(ByteBuffer data) {
        return Hex.encodeHex(data, true);
    }

    protected static char[] encodeHex(ByteBuffer byteBuffer, char[] toDigits) {
        return Hex.encodeHex(Hex.toByteArray(byteBuffer), toDigits);
    }

    public static String encodeHexStr(byte[] data) {
        return Hex.encodeHexStr(data, true);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return new String(Hex.encodeHex(data, toLowerCase));
    }

    public static String encodeHexStr(ByteBuffer data) {
        return new String(Hex.encodeHex(data));
    }

    public static String encodeHexStr(ByteBuffer data, boolean toLowerCase) {
        return new String(Hex.encodeHex(data, toLowerCase));
    }

    private static byte[] toByteArray(ByteBuffer byteBuffer) {
        byte[] byteArray;
        int remaining = byteBuffer.remaining();
        if (byteBuffer.hasArray() && remaining == (byteArray = byteBuffer.array()).length) {
            byteBuffer.position(remaining);
            return byteArray;
        }
        byteArray = new byte[remaining];
        byteBuffer.get(byteArray);
        return byteArray;
    }

    public static int toDigit(char ch, int index) throws DecoderException {
        int digit = Character.digit(ch, 16);
        if (digit < 0) {
            throw new DecoderException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static byte[] decode(byte[] array, Charset charset) throws DecoderException {
        return Hex.decodeHex(new String(array, charset).toCharArray());
    }

    public static byte[] decode(ByteBuffer buffer, Charset charset) throws DecoderException {
        return Hex.decodeHex(new String(Hex.toByteArray(buffer), charset).toCharArray());
    }

    public static Object decode(Object object, Charset charset) throws DecoderException {
        if (object instanceof String) {
            return Hex.decode(((String)object).toCharArray(), charset);
        }
        if (object instanceof byte[]) {
            return Hex.decode((byte[])object, charset);
        }
        if (object instanceof ByteBuffer) {
            return Hex.decode((ByteBuffer)object, charset);
        }
        try {
            return Hex.decodeHex((char[])object);
        }
        catch (ClassCastException e) {
            throw new DecoderException(e.getMessage(), e);
        }
    }

    public static byte[] encode(byte[] array, Charset charset) {
        return Hex.encodeHexStr(array).getBytes(charset);
    }

    public static byte[] encode(ByteBuffer array, Charset charset) {
        return Hex.encodeHexStr(array).getBytes(charset);
    }

    public static Object encode(Object object, Charset charset) throws EncoderException {
        byte[] byteArray;
        if (object instanceof String) {
            byteArray = ((String)object).getBytes(charset);
        } else if (object instanceof ByteBuffer) {
            byteArray = Hex.toByteArray((ByteBuffer)object);
        } else {
            try {
                byteArray = (byte[])object;
            }
            catch (ClassCastException e) {
                throw new EncoderException(e.getMessage(), e);
            }
        }
        return Hex.encodeHex(byteArray);
    }

    public static boolean isHexNumber(String value) {
        int index;
        int n = index = value.startsWith("-") ? 1 : 0;
        if (value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index)) {
            try {
                Long.decode(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static char[] encodeHex(String str, Charset charset) {
        return Hex.encodeHex(StrUtil.bytes((CharSequence)str, charset), true);
    }

    public static String encodeHexStr(String data, Charset charset) {
        return Hex.encodeHexStr(StrUtil.bytes((CharSequence)data, charset), true);
    }

    public static String encodeHexStr(String data) {
        return Hex.encodeHexStr(data, CharsetUtil.CHARSET_UTF_8);
    }

    public static String decodeHexStr(String hexStr) throws DecoderException {
        return Hex.decodeHexStr(hexStr, CharsetUtil.CHARSET_UTF_8);
    }

    public static String decodeHexStr(String hexStr, Charset charset) throws DecoderException {
        if (StrUtil.isEmpty(hexStr)) {
            return hexStr;
        }
        return StrUtil.str(Hex.decodeHex(hexStr), charset);
    }

    public static String decodeHexStr(char[] hexData, Charset charset) throws DecoderException {
        return StrUtil.str(Hex.decodeHex(hexData), charset);
    }

    public static String encodeColor(Color color) {
        return Hex.encodeColor(color, "#");
    }

    public static String encodeColor(Color color, String prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        String colorHex = Integer.toHexString(color.getRed());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getGreen());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getBlue());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        return builder.toString();
    }

    public static Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    public static String toUnicodeHex(int value) {
        StringBuilder builder = new StringBuilder(6);
        builder.append("\\u");
        String hex = Hex.toHex(value);
        int len = hex.length();
        if (len < 4) {
            builder.append("0000", 0, 4 - len);
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toUnicodeHex(char ch) {
        return "\\u" + DIGITS_LOWER[ch >> 12 & 0xF] + DIGITS_LOWER[ch >> 8 & 0xF] + DIGITS_LOWER[ch >> 4 & 0xF] + DIGITS_LOWER[ch & 0xF];
    }

    public static String toHex(int value) {
        return Integer.toHexString(value);
    }

    public static int hexToInt(String value) {
        return Integer.parseInt(value, 16);
    }

    public static String toHex(long value) {
        return Long.toHexString(value);
    }

    public static long hexToLong(String value) {
        return Long.parseLong(value, 16);
    }

    public static void appendHex(StringBuilder builder, byte b, boolean toLowerCase) {
        char[] toDigits = toLowerCase ? DIGITS_LOWER : DIGITS_UPPER;
        int high = (b & 0xF0) >>> 4;
        int low = b & 0xF;
        builder.append(toDigits[high]);
        builder.append(toDigits[low]);
    }

    public static BigInteger toBigInteger(String hexStr) {
        if (null == hexStr) {
            return null;
        }
        return new BigInteger(hexStr, 16);
    }

    public static String format(String hexStr) {
        int length = hexStr.length();
        StringBuilder builder = StrUtil.builder(length + length / 2);
        builder.append(hexStr.charAt(0)).append(hexStr.charAt(1));
        for (int i = 2; i < length - 1; i += 2) {
            builder.append(' ').append(hexStr.charAt(i)).append(hexStr.charAt(i + 1));
        }
        return builder.toString();
    }
}

