/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.lang.loader;

import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.lang.loader.LazyLoader;
import com.whaleal.icefrog.core.util.ObjectUtil;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class Lazy<T>
extends LazyLoader<T> {
    private static final Lazy<?> EMPTY = new Lazy<Object>(() -> null, null, true);
    private final Supplier<? extends T> supplier;
    private T value;
    private volatile boolean resolved;

    private Lazy(Supplier<? extends T> supplier) {
        this(supplier, null, false);
    }

    private Lazy(Supplier<? extends T> supplier, T value, boolean resolved) {
        Precondition.checkNotNull(supplier);
        this.supplier = supplier;
        this.value = value;
        this.resolved = resolved;
    }

    public static <T> Lazy<T> of(Supplier<? extends T> supplier) {
        return new Lazy<T>(supplier);
    }

    public static <T> Lazy<T> of(T value) {
        Precondition.notNull(value, "Value must not be null!", new Object[0]);
        return new Lazy<Object>(() -> value);
    }

    public static <T> Lazy<T> empty() {
        return EMPTY;
    }

    @Override
    protected T init() {
        T value = this.getNullable();
        if (value == null) {
            throw new IllegalStateException("Expected lazy evaluation to yield a non-null value but got null!");
        }
        return value;
    }

    public Optional<T> getOptional() {
        return Optional.ofNullable(this.getNullable());
    }

    public Lazy<T> or(Supplier<? extends T> supplier) {
        Precondition.notNull(supplier, "Supplier must not be null!", new Object[0]);
        return Lazy.of(() -> this.orElseGet(supplier));
    }

    public Lazy<T> or(T value) {
        Precondition.notNull(value, "Value must not be null!", new Object[0]);
        return Lazy.of(() -> this.orElse(value));
    }

    public T orElse(T value) {
        T nullable = this.getNullable();
        return nullable == null ? value : nullable;
    }

    private T orElseGet(Supplier<? extends T> supplier) {
        Precondition.notNull(supplier, "Default value supplier must not be null!", new Object[0]);
        T value = this.getNullable();
        return value == null ? supplier.get() : value;
    }

    public <S> Lazy<S> map(Function<? super T, ? extends S> function) {
        Precondition.notNull(function, "Function must not be null!", new Object[0]);
        return Lazy.of(() -> function.apply((T)this.get()));
    }

    public <S> Lazy<S> flatMap(Function<? super T, Lazy<? extends S>> function) {
        Precondition.notNull(function, "Function must not be null!", new Object[0]);
        return Lazy.of(() -> ((Lazy)function.apply((T)this.get())).get());
    }

    public T getNullable() {
        if (this.resolved) {
            return this.value;
        }
        this.value = this.supplier.get();
        this.resolved = true;
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Lazy)) {
            return false;
        }
        Lazy lazy = (Lazy)o;
        if (this.resolved != lazy.resolved) {
            return false;
        }
        if (!ObjectUtil.nullSafeEquals(this.supplier, lazy.supplier)) {
            return false;
        }
        return ObjectUtil.nullSafeEquals(this.value, lazy.value);
    }

    public int hashCode() {
        int result = ObjectUtil.nullSafeHashCode(this.supplier);
        result = 31 * result + ObjectUtil.nullSafeHashCode(this.value);
        result = 31 * result + (this.resolved ? 1 : 0);
        return result;
    }
}

