/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.core.util;

import com.whaleal.icefrog.core.lang.PatternPool;
import com.whaleal.icefrog.core.lang.Validator;
import com.whaleal.icefrog.core.util.ReUtil;
import com.whaleal.icefrog.core.util.StrUtil;

public class PhoneUtil {
    public static boolean isMobile(CharSequence value) {
        return Validator.isMatchRegex(PatternPool.MOBILE, value);
    }

    public static boolean isMobileHk(CharSequence value) {
        return Validator.isMatchRegex(PatternPool.MOBILE_HK, value);
    }

    public static boolean isMobileTw(CharSequence value) {
        return Validator.isMatchRegex(PatternPool.MOBILE_TW, value);
    }

    public static boolean isMobileMo(CharSequence value) {
        return Validator.isMatchRegex(PatternPool.MOBILE_MO, value);
    }

    public static boolean isTel(CharSequence value) {
        return Validator.isMatchRegex(PatternPool.TEL, value);
    }

    public static boolean isTel400800(CharSequence value) {
        return Validator.isMatchRegex(PatternPool.TEL_400_800, value);
    }

    public static boolean isPhone(CharSequence value) {
        return PhoneUtil.isMobile(value) || PhoneUtil.isTel400800(value) || PhoneUtil.isMobileHk(value) || PhoneUtil.isMobileTw(value) || PhoneUtil.isMobileMo(value);
    }

    public static CharSequence hideBefore(CharSequence phone) {
        return StrUtil.hide(phone, 0, 7);
    }

    public static CharSequence hideBetween(CharSequence phone) {
        return StrUtil.hide(phone, 3, 7);
    }

    public static CharSequence hideAfter(CharSequence phone) {
        return StrUtil.hide(phone, 7, 11);
    }

    public static CharSequence subBefore(CharSequence phone) {
        return StrUtil.sub(phone, 0, 3);
    }

    public static CharSequence subBetween(CharSequence phone) {
        return StrUtil.sub(phone, 3, 7);
    }

    public static CharSequence subAfter(CharSequence phone) {
        return StrUtil.sub(phone, 7, 11);
    }

    public static CharSequence subTelBefore(CharSequence value) {
        return ReUtil.getGroup1(PatternPool.TEL, value);
    }

    public static CharSequence subTelAfter(CharSequence value) {
        return ReUtil.get(PatternPool.TEL, value, 2);
    }
}

