/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.db.ds.c3p0;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.db.DbRuntimeException;
import com.whaleal.icefrog.db.ds.AbstractDSFactory;
import com.whaleal.icefrog.setting.Setting;
import com.whaleal.icefrog.setting.dialect.Props;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.sql.DataSource;

public class C3p0DSFactory
extends AbstractDSFactory {
    public static final String DS_NAME = "C3P0";
    private static final long serialVersionUID = -6090788225842047281L;

    public C3p0DSFactory() {
        this((Setting)null);
    }

    public C3p0DSFactory(Setting setting) {
        super(DS_NAME, ComboPooledDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setJdbcUrl(jdbcUrl);
        try {
            ds.setDriverClass(driver);
        }
        catch (PropertyVetoException e) {
            throw new DbRuntimeException(e);
        }
        ds.setUser(user);
        ds.setPassword(pass);
        Props connProps = new Props();
        for (String key : KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemoveStr(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            connProps.setProperty(key, connValue);
        }
        ds.setProperties((Properties)connProps);
        poolSetting.toBean(ds);
        return ds;
    }
}

