/*
 * Decompiled with CFR 0.152.
 */
package com.whaleal.icefrog.extra.servlet;

import com.whaleal.icefrog.core.bean.BeanUtil;
import com.whaleal.icefrog.core.bean.copier.CopyOptions;
import com.whaleal.icefrog.core.bean.copier.ValueProvider;
import com.whaleal.icefrog.core.collection.ArrayIter;
import com.whaleal.icefrog.core.collection.IterUtil;
import com.whaleal.icefrog.core.exceptions.UtilException;
import com.whaleal.icefrog.core.io.FileUtil;
import com.whaleal.icefrog.core.io.IORuntimeException;
import com.whaleal.icefrog.core.io.IoUtil;
import com.whaleal.icefrog.core.map.CaseInsensitiveMap;
import com.whaleal.icefrog.core.map.MapUtil;
import com.whaleal.icefrog.core.net.NetUtil;
import com.whaleal.icefrog.core.net.multipart.MultipartFormData;
import com.whaleal.icefrog.core.net.multipart.UploadSetting;
import com.whaleal.icefrog.core.util.ArrayUtil;
import com.whaleal.icefrog.core.util.CharsetUtil;
import com.whaleal.icefrog.core.util.ObjectUtil;
import com.whaleal.icefrog.core.util.ReflectUtil;
import com.whaleal.icefrog.core.util.StrUtil;
import com.whaleal.icefrog.core.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtil {
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_TRACE = "TRACE";

    public static Map<String, String[]> getParams(ServletRequest request) {
        Map map = request.getParameterMap();
        return Collections.unmodifiableMap(map);
    }

    public static Map<String, String> getParamMap(ServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String[]> entry : ServletUtil.getParams(request).entrySet()) {
            params.put(entry.getKey(), ArrayUtil.join((Object[])entry.getValue(), (CharSequence)","));
        }
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getBody(ServletRequest request) {
        try (BufferedReader reader = request.getReader();){
            String string = IoUtil.read(reader);
            return string;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static byte[] getBodyBytes(ServletRequest request) {
        try {
            return IoUtil.readBytes((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static <T> T fillBean(final ServletRequest request, T bean, CopyOptions copyOptions) {
        final String beanName = StrUtil.lowerFirst(bean.getClass().getSimpleName());
        return BeanUtil.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                String[] values = request.getParameterValues(key);
                if (ArrayUtil.isEmpty(values) && ArrayUtil.isEmpty(values = request.getParameterValues(beanName + "." + key))) {
                    return null;
                }
                if (1 == values.length) {
                    return values[0];
                }
                return values;
            }

            @Override
            public boolean containsKey(String key) {
                return null != request.getParameter(key) || null != request.getParameter(beanName + "." + key);
            }
        }, copyOptions);
    }

    public static <T> T fillBean(ServletRequest request, T bean, boolean isIgnoreError) {
        return ServletUtil.fillBean(request, bean, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T toBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return ServletUtil.fillBean(request, ReflectUtil.newInstanceIfPossible(beanClass), isIgnoreError);
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty(otherHeaderNames)) {
            headers = ArrayUtil.addAll(headers, otherHeaderNames);
        }
        return ServletUtil.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown(ip)) continue;
            return NetUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return NetUtil.getMultistageReverseProxyIp(ip);
    }

    public static MultipartFormData getMultipart(ServletRequest request) throws IORuntimeException {
        return ServletUtil.getMultipart(request, new UploadSetting());
    }

    public static MultipartFormData getMultipart(ServletRequest request, UploadSetting uploadSetting) throws IORuntimeException {
        MultipartFormData formData = new MultipartFormData(uploadSetting);
        try {
            formData.parseRequestStream((InputStream)request.getInputStream(), CharsetUtil.charset(request.getCharacterEncoding()));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return formData;
    }

    public static Map<String, String> getHeaderMap(HttpServletRequest request) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        return headerMap;
    }

    public static String getHeaderIgnoreCase(HttpServletRequest request, String nameIgnoreCase) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name == null || !name.equalsIgnoreCase(nameIgnoreCase)) continue;
            return request.getHeader(name);
        }
        return null;
    }

    public static String getHeader(HttpServletRequest request, String name, String charsetName) {
        return ServletUtil.getHeader(request, name, CharsetUtil.charset(charsetName));
    }

    public static String getHeader(HttpServletRequest request, String name, Charset charset) {
        String header = request.getHeader(name);
        if (null != header) {
            return CharsetUtil.convert(header, CharsetUtil.CHARSET_ISO_8859_1, charset);
        }
        return null;
    }

    public static boolean isIE(HttpServletRequest request) {
        String userAgent = ServletUtil.getHeaderIgnoreCase(request, "User-Agent");
        if (StrUtil.isNotBlank(userAgent)) {
            return (userAgent = userAgent.toUpperCase()).contains("MSIE") || userAgent.contains("TRIDENT");
        }
        return false;
    }

    public static boolean isGetMethod(HttpServletRequest request) {
        return METHOD_GET.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostMethod(HttpServletRequest request) {
        return METHOD_POST.equalsIgnoreCase(request.getMethod());
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!ServletUtil.isPostMethod(request)) {
            return false;
        }
        String contentType = request.getContentType();
        if (StrUtil.isBlank(contentType)) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static Cookie getCookie(HttpServletRequest httpServletRequest, String name) {
        return ServletUtil.readCookieMap(httpServletRequest).get(name);
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest httpServletRequest) {
        Cookie[] cookies = httpServletRequest.getCookies();
        if (ArrayUtil.isEmpty(cookies)) {
            return MapUtil.empty();
        }
        return IterUtil.toMap(new ArrayIter<Cookie>((E[])httpServletRequest.getCookies()), new CaseInsensitiveMap(), Cookie::getName);
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value) {
        response.addCookie(new Cookie(name, value));
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        Cookie cookie = new Cookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setPath(path);
        ServletUtil.addCookie(response, cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        ServletUtil.addCookie(response, name, value, maxAgeInSeconds, "/", null);
    }

    public static PrintWriter getWriter(HttpServletResponse response) throws IORuntimeException {
        try {
            return response.getWriter();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(HttpServletResponse response, String text, String contentType) {
        response.setContentType(contentType);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(text);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(HttpServletResponse response, File file) {
        String fileName = file.getName();
        String contentType = ObjectUtil.defaultIfNull(FileUtil.getMimeType(fileName), "application/octet-stream");
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream(file);
            ServletUtil.write(response, in, contentType, fileName);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType, String fileName) {
        String charset = ObjectUtil.defaultIfNull(response.getCharacterEncoding(), "UTF-8");
        response.setHeader("Content-Disposition", StrUtil.format("attachment;filename={}", URLUtil.encode(fileName, CharsetUtil.charset(charset))));
        response.setContentType(contentType);
        ServletUtil.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in, String contentType) {
        response.setContentType(contentType);
        ServletUtil.write(response, in);
    }

    public static void write(HttpServletResponse response, InputStream in) {
        ServletUtil.write(response, in, 8192);
    }

    public static void write(HttpServletResponse response, InputStream in, int bufferSize) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IoUtil.copy(in, (OutputStream)out, bufferSize);
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        finally {
            IoUtil.close((Closeable)out);
            IoUtil.close(in);
        }
    }

    public static void setHeader(HttpServletResponse response, String name, Object value) {
        if (value instanceof String) {
            response.setHeader(name, (String)value);
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            response.setDateHeader(name, ((Date)value).getTime());
        } else if (value instanceof Integer || "int".equalsIgnoreCase(value.getClass().getSimpleName())) {
            response.setIntHeader(name, ((Integer)value).intValue());
        } else {
            response.setHeader(name, value.toString());
        }
    }
}

