package com.whaleal.icefrog.core.comparator;

import com.whaleal.icefrog.core.lang.Precondition;
import com.whaleal.icefrog.core.util.ClassUtil;

import java.lang.reflect.Field;

/**
 * Bean字段排序器<br>
 * 参阅feilong-core中的PropertyComparator
 *
 * @param <T> 被比较的Bean
 * @author Looly
 * @author wh
 */
public class FieldsComparator<T> extends NullComparator<T> {
    private static final long serialVersionUID = 8649196282886500803L;

    /**
     * 构造
     *
     * @param beanClass  Bean类
     * @param fieldNames 多个字段名
     */
    public FieldsComparator( Class<T> beanClass, String... fieldNames ) {
        this(true, beanClass, fieldNames);
    }

    /**
     * 构造
     *
     * @param nullGreater 是否{@code null}在后
     * @param beanClass   Bean类
     * @param fieldNames  多个字段名
     */
    public FieldsComparator( boolean nullGreater, Class<T> beanClass, String... fieldNames ) {
        super(nullGreater, ( a, b ) -> {
            Field field;
            for (String fieldName : fieldNames) {
                field = ClassUtil.getDeclaredField(beanClass, fieldName);
                Precondition.notNull(field, "Field [{}] not found in Class [{}]", fieldName, beanClass.getName());
                final int compare = new FieldComparator<>(field).compare(a, b);
                if (0 != compare) {
                    return compare;
                }
            }
            return 0;
        });
    }

}
